/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.trees.patterns;

import java.util.Collections;
import java.util.List;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.namespace.QName;
import org.gcube.data.trees.data.Edge;
import org.gcube.data.trees.patterns.EdgePattern;
import org.gcube.data.trees.patterns.Pattern;

@XmlRootElement(name="one")
public class OnePattern
extends EdgePattern {
    private static final long serialVersionUID = 1L;
    private static EdgePattern.Range RANGE = new EdgePattern.Range(1, 1);
    static final String NAME = "one";

    OnePattern() {
    }

    public OnePattern(QName l, Pattern predicate) {
        super(l, predicate);
    }

    @Override
    public boolean matches(List<Edge> edges) {
        if (edges.size() != 1) {
            return false;
        }
        return this.pattern().matches(edges.get(0).target());
    }

    @Override
    public List<Edge> prune(List<Edge> edges) throws Exception {
        if (edges.size() != 1) {
            throw new Exception("expected one " + this.label() + " found " + edges.size());
        }
        Edge match = edges.get(0);
        this.pattern().prune(match.target());
        return Collections.singletonList(match);
    }

    @Override
    public EdgePattern.Range range() {
        return RANGE;
    }

    @Override
    public String name() {
        return NAME;
    }
}

