/*
 * Decompiled with CFR 0.152.
 */
package org.portletbridge.xsl;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Templates;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLFilterImpl;
import org.xml.sax.helpers.XMLReaderFactory;

public class XslFilter
extends XMLFilterImpl {
    private Templates templates;
    private TransformerHandler transformerHandler;
    private Map context = null;

    public XslFilter(Templates templates) throws TransformerConfigurationException {
        this.templates = templates;
        try {
            TransformerFactory tfactory = TransformerFactory.newInstance();
            if (!tfactory.getFeature("http://javax.xml.transform.sax.SAXSource/feature")) {
                throw new TransformerConfigurationException("Can't do ChainedXslFilter because tfactory is not a SAXTransformerFactory");
            }
            SAXTransformerFactory stfactory = (SAXTransformerFactory)tfactory;
            this.transformerHandler = stfactory.newTransformerHandler(templates);
        }
        catch (FactoryConfigurationError ex1) {
            throw new TransformerConfigurationException(ex1.toString());
        }
    }

    public void setParent(XMLReader parent) {
        super.setParent(parent);
        if (null != parent.getContentHandler()) {
            this.setContentHandler(parent.getContentHandler());
        }
        this.setupParse();
    }

    public void parse(InputSource input) throws SAXException, IOException {
        if (null == this.getParent()) {
            XMLReader reader = null;
            try {
                SAXParserFactory factory = SAXParserFactory.newInstance();
                factory.setNamespaceAware(true);
                SAXParser jaxpParser = factory.newSAXParser();
                reader = jaxpParser.getXMLReader();
            }
            catch (ParserConfigurationException ex) {
                throw new SAXException(ex);
            }
            catch (FactoryConfigurationError ex1) {
                throw new SAXException(ex1.toString());
            }
            catch (NoSuchMethodError ex2) {
            }
            catch (AbstractMethodError ame) {
                // empty catch block
            }
            XMLReader parent = reader == null ? XMLReaderFactory.createXMLReader() : reader;
            try {
                parent.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
            }
            catch (SAXException se) {
                // empty catch block
            }
            this.setParent(parent);
        } else {
            this.setupParse();
        }
        if (this.context != null) {
            Iterator iter = this.context.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                this.transformerHandler.getTransformer().setParameter((String)entry.getKey(), entry.getValue());
            }
        }
        this.getParent().parse(input);
    }

    public void parse(String systemId) throws SAXException, IOException {
        this.parse(new InputSource(systemId));
    }

    private void setupParse() {
        XMLReader p = this.getParent();
        if (p == null) {
            throw new NullPointerException("No parent for filter");
        }
        TransformerHandler ch = this.transformerHandler;
        p.setContentHandler(ch);
        if (ch instanceof EntityResolver) {
            p.setEntityResolver((EntityResolver)((Object)ch));
        } else {
            p.setEntityResolver(this);
        }
        if (ch instanceof DTDHandler) {
            p.setDTDHandler(ch);
        } else {
            p.setDTDHandler(this);
        }
        ErrorListener elistener = this.transformerHandler.getTransformer().getErrorListener();
        if (null != elistener && elistener instanceof ErrorHandler) {
            p.setErrorHandler((ErrorHandler)((Object)elistener));
        } else {
            p.setErrorHandler(this);
        }
    }

    public void setContentHandler(ContentHandler handler) {
        this.transformerHandler.setResult(new SAXResult(handler));
    }

    public void setErrorListener(ErrorListener handler) {
        this.transformerHandler.getTransformer().setErrorListener(handler);
    }

    public Map getContext() {
        return this.context;
    }

    public void setContext(Map context) {
        this.context = context;
    }
}

