/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.taglib.util;

import com.liferay.portal.kernel.io.unsync.UnsyncStringWriter;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.PipingServletResponse;
import com.liferay.portal.kernel.servlet.ServletContextPool;
import com.liferay.portal.kernel.template.Template;
import com.liferay.portal.kernel.template.TemplateManagerUtil;
import com.liferay.portal.kernel.template.TemplateResource;
import com.liferay.portal.kernel.template.TemplateResourceLoaderUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.UnsyncPrintWriterPool;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.PortletConstants;
import com.liferay.portal.model.Theme;
import com.liferay.portal.theme.PortletDisplay;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.taglib.util.VelocityTaglibImpl;
import com.liferay.util.freemarker.FreeMarkerTaglibFactoryUtil;
import freemarker.ext.servlet.HttpRequestHashModel;
import freemarker.ext.servlet.ServletContextHashModel;
import freemarker.template.ObjectWrapper;
import freemarker.template.TemplateHashModel;
import java.io.IOException;
import java.io.Writer;
import javax.servlet.GenericServlet;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.apache.struts.tiles.ComponentContext;

public class ThemeUtil {
    private static Log _log = LogFactoryUtil.getLog(ThemeUtil.class);

    public static String getPortletId(HttpServletRequest request) {
        String portletId = null;
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        if (themeDisplay != null) {
            PortletDisplay portletDisplay = themeDisplay.getPortletDisplay();
            portletId = portletDisplay.getId();
        }
        return portletId;
    }

    public static void include(ServletContext servletContext, HttpServletRequest request, HttpServletResponse response, PageContext pageContext, String path, Theme theme) throws Exception {
        String extension = theme.getTemplateExtension();
        if (extension.equals("ftl")) {
            ThemeUtil.includeFTL(servletContext, request, pageContext, path, theme, true);
        } else if (extension.equals("vm")) {
            ThemeUtil.includeVM(servletContext, request, pageContext, path, theme, true);
        } else {
            path = String.valueOf(theme.getTemplatesPath()) + "/" + path;
            ThemeUtil.includeJSP(servletContext, request, response, path, theme);
        }
    }

    public static String includeFTL(ServletContext servletContext, HttpServletRequest request, PageContext pageContext, String path, Theme theme, boolean write) throws Exception {
        return ThemeUtil.doDispatch(servletContext, request, null, pageContext, path, theme, write, "ftl");
    }

    public static void includeJSP(ServletContext servletContext, HttpServletRequest request, HttpServletResponse response, String path, Theme theme) throws Exception {
        ThemeUtil.doDispatch(servletContext, request, response, null, path, theme, true, "jsp");
    }

    public static String includeVM(ServletContext servletContext, HttpServletRequest request, PageContext pageContext, String path, Theme theme, boolean write) throws Exception {
        return ThemeUtil.doDispatch(servletContext, request, null, pageContext, path, theme, write, "vm");
    }

    protected static String doDispatch(ServletContext servletContext, HttpServletRequest request, HttpServletResponse response, PageContext pageContext, String path, Theme theme, boolean write, String extension) throws Exception {
        String pluginServletContextName = GetterUtil.getString((String)theme.getServletContextName());
        ServletContext pluginServletContext = ServletContextPool.get((String)pluginServletContextName);
        ClassLoader pluginClassLoader = null;
        if (pluginServletContext != null) {
            pluginClassLoader = (ClassLoader)pluginServletContext.getAttribute("PLUGIN_CLASS_LOADER");
        }
        Thread currentThread = Thread.currentThread();
        ClassLoader contextClassLoader = currentThread.getContextClassLoader();
        if (pluginClassLoader != null && pluginClassLoader != contextClassLoader) {
            currentThread.setContextClassLoader(pluginClassLoader);
        }
        try {
            if (extension.equals("ftl")) {
                String string = ThemeUtil.doIncludeFTL(servletContext, request, pageContext, path, theme, false, write);
                return string;
            }
            if (extension.equals("jsp")) {
                ThemeUtil.doIncludeJSP(servletContext, request, response, path, theme);
            } else if (extension.equals("vm")) {
                String string = ThemeUtil.doIncludeVM(servletContext, request, pageContext, path, theme, false, write);
                return string;
            }
            return null;
        }
        finally {
            if (pluginClassLoader != null && pluginClassLoader != contextClassLoader) {
                currentThread.setContextClassLoader(contextClassLoader);
            }
        }
    }

    protected static String doIncludeFTL(ServletContext servletContext, HttpServletRequest request, PageContext pageContext, String path, Theme theme, boolean restricted, boolean write) throws Exception {
        String servletContextName = GetterUtil.getString((String)theme.getServletContextName());
        if (ServletContextPool.get((String)servletContextName) == null) {
            ServletContextPool.put((String)servletContextName, (ServletContext)servletContext);
        }
        String portletId = ThemeUtil.getPortletId(request);
        String resourcePath = theme.getResourcePath(servletContext, portletId, path);
        if (Validator.isNotNull((String)portletId) && PortletConstants.hasInstanceId((String)portletId) && !TemplateResourceLoaderUtil.hasTemplateResource((String)"ftl", (String)resourcePath)) {
            String rootPortletId = PortletConstants.getRootPortletId((String)portletId);
            resourcePath = theme.getResourcePath(servletContext, rootPortletId, path);
        }
        if (Validator.isNotNull((String)portletId) && !TemplateResourceLoaderUtil.hasTemplateResource((String)"ftl", (String)resourcePath)) {
            resourcePath = theme.getResourcePath(servletContext, null, path);
        }
        if (!TemplateResourceLoaderUtil.hasTemplateResource((String)"ftl", (String)resourcePath)) {
            _log.error((Object)(String.valueOf(resourcePath) + " does not exist"));
            return null;
        }
        TemplateResource templateResource = TemplateResourceLoaderUtil.getTemplateResource((String)"ftl", (String)resourcePath);
        Template template = TemplateManagerUtil.getTemplate((String)"ftl", (TemplateResource)templateResource, (boolean)restricted);
        template.prepare(request);
        ServletContext themeServletContext = ServletContextPool.get((String)servletContextName);
        template.put("themeServletContext", (Object)themeServletContext);
        HttpServletResponse response = (HttpServletResponse)pageContext.getResponse();
        Object writer = null;
        writer = write ? UnsyncPrintWriterPool.borrow((Writer)pageContext.getOut()) : new UnsyncStringWriter();
        VelocityTaglibImpl velocityTaglib = new VelocityTaglibImpl(servletContext, request, (HttpServletResponse)new PipingServletResponse(response, (Writer)writer), pageContext, template);
        template.put("writer", writer);
        template.put("taglibLiferay", (Object)velocityTaglib);
        template.put("theme", (Object)velocityTaglib);
        TemplateHashModel portalTaglib = FreeMarkerTaglibFactoryUtil.createTaglibFactory((ServletContext)servletContext);
        template.put("PortalJspTagLibs", (Object)portalTaglib);
        TemplateHashModel themeTaglib = FreeMarkerTaglibFactoryUtil.createTaglibFactory((ServletContext)themeServletContext);
        template.put("ThemeJspTaglibs", (Object)themeTaglib);
        final Servlet servlet = (Servlet)pageContext.getPage();
        GenericServlet genericServlet = null;
        if (servlet instanceof GenericServlet) {
            genericServlet = (GenericServlet)servlet;
        } else {
            genericServlet = new GenericServlet(){

                public void service(ServletRequest servletRequest, ServletResponse servletResponse) throws IOException, ServletException {
                    servlet.service(servletRequest, servletResponse);
                }
            };
            genericServlet.init(pageContext.getServletConfig());
        }
        ServletContextHashModel servletContextHashModel = new ServletContextHashModel(genericServlet, ObjectWrapper.DEFAULT_WRAPPER);
        template.put("Application", (Object)servletContextHashModel);
        HttpRequestHashModel httpRequestHashModel = new HttpRequestHashModel(request, response, ObjectWrapper.DEFAULT_WRAPPER);
        template.put("Request", (Object)httpRequestHashModel);
        template.processTemplate((Writer)writer);
        if (write) {
            return null;
        }
        return writer.toString();
    }

    protected static void doIncludeJSP(ServletContext servletContext, HttpServletRequest request, HttpServletResponse response, String path, Theme theme) throws Exception {
        ThemeUtil.insertTilesVariables(request);
        if (theme.isWARFile()) {
            ServletContext themeServletContext = servletContext.getContext(theme.getContextPath());
            if (themeServletContext == null) {
                _log.error((Object)("Theme " + theme.getThemeId() + " cannot find its " + "servlet context at " + theme.getServletContextName()));
            } else {
                RequestDispatcher requestDispatcher = themeServletContext.getRequestDispatcher(path);
                if (requestDispatcher == null) {
                    _log.error((Object)("Theme " + theme.getThemeId() + " does not have " + path));
                } else {
                    requestDispatcher.include((ServletRequest)request, (ServletResponse)response);
                }
            }
        } else {
            RequestDispatcher requestDispatcher = servletContext.getRequestDispatcher(path);
            if (requestDispatcher == null) {
                _log.error((Object)("Theme " + theme.getThemeId() + " does not have " + path));
            } else {
                requestDispatcher.include((ServletRequest)request, (ServletResponse)response);
            }
        }
    }

    protected static String doIncludeVM(ServletContext servletContext, HttpServletRequest request, PageContext pageContext, String page, Theme theme, boolean restricted, boolean write) throws Exception {
        String servletContextName = GetterUtil.getString((String)theme.getServletContextName());
        if (ServletContextPool.get((String)servletContextName) == null) {
            ServletContextPool.put((String)servletContextName, (ServletContext)servletContext);
        }
        String portletId = ThemeUtil.getPortletId(request);
        String resourcePath = theme.getResourcePath(servletContext, portletId, page);
        boolean checkResourceExists = true;
        if (Validator.isNotNull((String)portletId)) {
            if (PortletConstants.hasInstanceId((String)portletId) && (checkResourceExists = !TemplateResourceLoaderUtil.hasTemplateResource((String)"vm", (String)resourcePath))) {
                String rootPortletId = PortletConstants.getRootPortletId((String)portletId);
                resourcePath = theme.getResourcePath(servletContext, rootPortletId, page);
            }
            if (checkResourceExists && (checkResourceExists = !TemplateResourceLoaderUtil.hasTemplateResource((String)"vm", (String)resourcePath))) {
                resourcePath = theme.getResourcePath(servletContext, null, page);
            }
        }
        if (checkResourceExists && !TemplateResourceLoaderUtil.hasTemplateResource((String)"vm", (String)resourcePath)) {
            _log.error((Object)(String.valueOf(resourcePath) + " does not exist"));
            return null;
        }
        TemplateResource templateResource = TemplateResourceLoaderUtil.getTemplateResource((String)"vm", (String)resourcePath);
        if (templateResource == null) {
            throw new Exception("Unable to load template resource " + resourcePath);
        }
        Template template = TemplateManagerUtil.getTemplate((String)"vm", (TemplateResource)templateResource, (boolean)restricted);
        template.prepare(request);
        template.put("pageContext", (Object)pageContext);
        ServletContext themeServletContext = ServletContextPool.get((String)servletContextName);
        template.put("themeServletContext", (Object)themeServletContext);
        HttpServletResponse response = (HttpServletResponse)pageContext.getResponse();
        Object writer = null;
        writer = write ? pageContext.getOut() : new UnsyncStringWriter();
        VelocityTaglibImpl velocityTaglib = new VelocityTaglibImpl(servletContext, request, (HttpServletResponse)new PipingServletResponse(response, (Writer)writer), pageContext, template);
        template.put("writer", writer);
        template.put("taglibLiferay", (Object)velocityTaglib);
        template.put("theme", (Object)velocityTaglib);
        template.processTemplate((Writer)writer);
        if (write) {
            return null;
        }
        return ((UnsyncStringWriter)writer).toString();
    }

    protected static void insertTilesVariables(HttpServletRequest request) {
        ComponentContext componentContext = (ComponentContext)request.getAttribute("org.apache.struts.taglib.tiles.CompContext");
        if (componentContext == null) {
            return;
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        String tilesTitle = (String)componentContext.getAttribute("title");
        String tilesContent = (String)componentContext.getAttribute("content");
        boolean tilesSelectable = GetterUtil.getBoolean((String)((String)componentContext.getAttribute("selectable")));
        themeDisplay.setTilesTitle(tilesTitle);
        themeDisplay.setTilesContent(tilesContent);
        themeDisplay.setTilesSelectable(tilesSelectable);
    }
}

