/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.pacl;

import com.liferay.portal.kernel.servlet.ServletContextPool;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.security.lang.PortalSecurityManager;
import com.liferay.portal.security.lang.SecurityManagerUtil;
import com.liferay.portal.security.pacl.ActivePACLPolicy;
import com.liferay.portal.security.pacl.GeneratingPACLPolicy;
import com.liferay.portal.security.pacl.InactivePACLPolicy;
import com.liferay.portal.security.pacl.PACLPolicy;
import com.liferay.portal.security.pacl.URLWrapper;
import com.liferay.portal.util.PropsValues;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.Policy;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletContext;

public class PACLPolicyManager {
    private static Map<ClassLoader, PACLPolicy> _classLoaderPACLPolicies = new ConcurrentHashMap<ClassLoader, PACLPolicy>();
    private static PACLPolicy _defaultPACLPolicy = new InactivePACLPolicy("", PACLPolicyManager.class.getClassLoader(), new Properties());
    private static Map<URLWrapper, PACLPolicy> _urlPACLPolicies = new ConcurrentHashMap<URLWrapper, PACLPolicy>();

    public static PACLPolicy buildPACLPolicy(String servletContextName, ClassLoader classLoader, Properties properties) {
        String value = properties.getProperty("security-manager-enabled", "false");
        if (value.equals("generate")) {
            return new GeneratingPACLPolicy(servletContextName, classLoader, properties);
        }
        if (GetterUtil.getBoolean((String)value)) {
            return new ActivePACLPolicy(servletContextName, classLoader, properties);
        }
        return new InactivePACLPolicy(servletContextName, classLoader, properties);
    }

    public static PACLPolicy getDefaultPACLPolicy() {
        return _defaultPACLPolicy;
    }

    public static PACLPolicy getPACLPolicy(ClassLoader classLoader) {
        if (classLoader == null) {
            return null;
        }
        return AccessController.doPrivileged(new PACLPolicyPrivilegedAction(classLoader));
    }

    public static PACLPolicy getPACLPolicy(ProtectionDomain protectionDomain) {
        if (protectionDomain == null) {
            return null;
        }
        return AccessController.doPrivileged(new PACLPolicyPrivilegedAction(protectionDomain));
    }

    public static PACLPolicy getPACLPolicy(URL locationURL) {
        if (locationURL == null) {
            return null;
        }
        return AccessController.doPrivileged(new PACLPolicyPrivilegedAction(locationURL));
    }

    public static void register(ClassLoader classLoader, PACLPolicy paclPolicy) {
        ServletContext servletContext;
        String realPath;
        List<URL> urLs = paclPolicy.getURLs();
        if (classLoader instanceof URLClassLoader) {
            URLClassLoader urlClassLoader = (URLClassLoader)classLoader;
            URL[] uRLArray = urlClassLoader.getURLs();
            int n = uRLArray.length;
            int n2 = 0;
            while (n2 < n) {
                URL url = uRLArray[n2];
                String path = url.getPath();
                if (!path.startsWith(PropsValues.LIFERAY_LIB_GLOBAL_SHARED_DIR)) {
                    urLs.add(url);
                    _urlPACLPolicies.put(new URLWrapper(url), paclPolicy);
                }
                ++n2;
            }
        }
        if ((realPath = (servletContext = ServletContextPool.get((String)paclPolicy.getServletContextName())).getRealPath("/")).endsWith("/")) {
            realPath = realPath.substring(0, realPath.length() - 1);
        }
        try {
            URL url = new URL("file", "", -1, realPath);
            urLs.add(url);
            _urlPACLPolicies.put(new URLWrapper(url), paclPolicy);
            url = new URL("file", "", -1, String.valueOf(realPath) + "/");
            urLs.add(url);
            _urlPACLPolicies.put(new URLWrapper(url), paclPolicy);
            url = new URL("file", "", -1, String.valueOf(realPath) + "/WEB-INF/classes/*");
            urLs.add(url);
            _urlPACLPolicies.put(new URLWrapper(url), paclPolicy);
        }
        catch (MalformedURLException murle) {
            throw new RuntimeException(murle);
        }
        _classLoaderPACLPolicies.put(classLoader, paclPolicy);
        PACLPolicyManager.refresh();
    }

    public static void unregister(ClassLoader classLoader) {
        PACLPolicy paclPolicy = _classLoaderPACLPolicies.remove(classLoader);
        for (URL url : paclPolicy.getURLs()) {
            _urlPACLPolicies.remove(url);
        }
        PACLPolicyManager.refresh();
    }

    private static void refresh() {
        PortalSecurityManager portalSecurityManager = SecurityManagerUtil.getPortalSecurityManager();
        Policy policy = portalSecurityManager.getPolicy();
        policy.refresh();
    }

    private static class PACLPolicyPrivilegedAction
    implements PrivilegedAction<PACLPolicy> {
        private ClassLoader _classLoader;
        private URL _locationURL;

        public PACLPolicyPrivilegedAction(ClassLoader classLoader) {
            this._classLoader = classLoader;
        }

        public PACLPolicyPrivilegedAction(ProtectionDomain protectionDomain) {
            this._classLoader = protectionDomain.getClassLoader();
            CodeSource codeSource = protectionDomain.getCodeSource();
            if (codeSource == null) {
                return;
            }
            this._locationURL = codeSource.getLocation();
        }

        public PACLPolicyPrivilegedAction(URL locationURL) {
            this._locationURL = locationURL;
        }

        @Override
        public PACLPolicy run() {
            PACLPolicy paclPolicy = this.getFromClassLoader();
            if (paclPolicy != null || this._classLoader != null || this._locationURL == null) {
                return paclPolicy;
            }
            return (PACLPolicy)_urlPACLPolicies.get(new URLWrapper(this._locationURL));
        }

        private PACLPolicy getFromClassLoader() {
            if (this._classLoader == null) {
                return null;
            }
            PACLPolicy paclPolicy = (PACLPolicy)_classLoaderPACLPolicies.get(this._classLoader);
            while (paclPolicy == null && this._classLoader.getParent() != null) {
                this._classLoader = this._classLoader.getParent();
                paclPolicy = (PACLPolicy)_classLoaderPACLPolicies.get(this._classLoader);
            }
            return paclPolicy;
        }
    }
}

