/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.connectionpool.impl;

import com.netflix.astyanax.connectionpool.BadHostDetector;
import com.netflix.astyanax.connectionpool.ConnectionPoolConfiguration;
import java.util.concurrent.LinkedBlockingQueue;

public class BadHostDetectorImpl
implements BadHostDetector {
    private final LinkedBlockingQueue<Long> timeouts = new LinkedBlockingQueue();
    private final ConnectionPoolConfiguration config;

    public BadHostDetectorImpl(ConnectionPoolConfiguration config) {
        this.config = config;
    }

    public String toString() {
        return "BadHostDetectorImpl[" + "count=" + this.config.getMaxTimeoutCount() + ",window=" + this.config.getTimeoutWindow() + "]";
    }

    @Override
    public BadHostDetector.Instance createInstance() {
        return new BadHostDetector.Instance(){

            @Override
            public boolean addTimeoutSample() {
                Long last;
                long currentTimeMillis = System.currentTimeMillis();
                BadHostDetectorImpl.this.timeouts.add(currentTimeMillis);
                return BadHostDetectorImpl.this.timeouts.size() > BadHostDetectorImpl.this.config.getMaxTimeoutCount() && currentTimeMillis - (last = (Long)BadHostDetectorImpl.this.timeouts.remove()) < (long)BadHostDetectorImpl.this.config.getTimeoutWindow();
            }
        };
    }

    @Override
    public void removeInstance(BadHostDetector.Instance instance) {
    }
}

