/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.test;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.netflix.astyanax.connectionpool.Connection;
import com.netflix.astyanax.connectionpool.ConnectionFactory;
import com.netflix.astyanax.connectionpool.ConnectionPoolConfiguration;
import com.netflix.astyanax.connectionpool.ConnectionPoolMonitor;
import com.netflix.astyanax.connectionpool.Host;
import com.netflix.astyanax.connectionpool.HostConnectionPool;
import com.netflix.astyanax.connectionpool.Operation;
import com.netflix.astyanax.connectionpool.OperationResult;
import com.netflix.astyanax.connectionpool.exceptions.ConnectionException;
import com.netflix.astyanax.connectionpool.exceptions.IsTimeoutException;
import com.netflix.astyanax.connectionpool.exceptions.ThrottledException;
import com.netflix.astyanax.connectionpool.exceptions.UnknownException;
import com.netflix.astyanax.connectionpool.impl.OperationResultImpl;
import com.netflix.astyanax.test.TestClient;
import com.netflix.astyanax.test.TestHostType;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public class TestConnectionFactory
implements ConnectionFactory<TestClient> {
    private final ConnectionPoolConfiguration config;
    private final ExecutorService executor = Executors.newFixedThreadPool(10, new ThreadFactoryBuilder().setDaemon(true).build());
    private final ConnectionPoolMonitor monitor;

    public TestConnectionFactory(ConnectionPoolConfiguration config, ConnectionPoolMonitor monitor) {
        this.config = config;
        this.monitor = monitor;
    }

    @Override
    public Connection<TestClient> createConnection(final HostConnectionPool<TestClient> pool) throws ThrottledException {
        return new Connection<TestClient>(){
            private ConnectionException lastException;
            private boolean isOpen = false;
            private AtomicLong operationCounter = new AtomicLong();

            @Override
            public <R> OperationResult<R> execute(Operation<TestClient, R> op) throws ConnectionException {
                long startTime = System.nanoTime();
                long latency = 0L;
                try {
                    TestHostType type = TestHostType.get(this.getHost().getPort());
                    OperationResult<R> result = type.execute(pool, op);
                    long now = System.nanoTime();
                    latency = now - startTime;
                    pool.addLatencySample(latency, now);
                    return new OperationResultImpl<R>(result.getHost(), result.getResult(), latency);
                }
                catch (Exception e) {
                    long now = System.nanoTime();
                    latency = now - startTime;
                    ConnectionException connectionException = !(e instanceof ConnectionException) ? new UnknownException(e) : (ConnectionException)e;
                    connectionException.setLatency(latency);
                    if (!(connectionException instanceof IsTimeoutException)) {
                        pool.addLatencySample(latency, now);
                    } else {
                        pool.addLatencySample(TimeUnit.NANOSECONDS.convert(TestConnectionFactory.this.config.getSocketTimeout(), TimeUnit.MILLISECONDS), System.nanoTime());
                    }
                    this.lastException = connectionException;
                    throw this.lastException;
                }
            }

            @Override
            public void close() {
                if (this.isOpen) {
                    TestConnectionFactory.this.monitor.incConnectionClosed(this.getHost(), this.lastException);
                    TestConnectionFactory.this.executor.submit(new Runnable(){

                        @Override
                        public void run() {
                            TestHostType type = TestHostType.get(this.getHost().getPort());
                            type.close();
                            isOpen = false;
                        }
                    });
                }
            }

            @Override
            public HostConnectionPool<TestClient> getHostConnectionPool() {
                return pool;
            }

            @Override
            public ConnectionException getLastException() {
                return this.lastException;
            }

            @Override
            public void open() throws ConnectionException {
                TestHostType type = TestHostType.get(this.getHost().getPort());
                try {
                    type.open(0L);
                    this.isOpen = true;
                    TestConnectionFactory.this.monitor.incConnectionCreated(this.getHost());
                }
                catch (ConnectionException e) {
                    this.lastException = e;
                    e.setHost(this.getHost());
                    TestConnectionFactory.this.monitor.incConnectionCreateFailed(this.getHost(), e);
                    throw e;
                }
            }

            @Override
            public void openAsync(final Connection.AsyncOpenCallback<TestClient> callback) {
                final 1 This = this;
                TestConnectionFactory.this.executor.submit(new Runnable(){

                    @Override
                    public void run() {
                        Thread.currentThread().setName("MockConnectionFactory");
                        try {
                            this.open();
                            callback.success(This);
                        }
                        catch (ConnectionException e) {
                            callback.failure(This, e);
                        }
                        catch (Exception e) {
                            callback.failure(This, new UnknownException("Error openning async connection", e));
                        }
                    }
                });
            }

            @Override
            public long getOperationCount() {
                return this.operationCounter.get();
            }

            @Override
            public Host getHost() {
                return pool.getHost();
            }

            @Override
            public void setMetadata(String key, Object obj) {
            }

            @Override
            public Object getMetadata(String key) {
                return null;
            }

            @Override
            public boolean hasMetadata(String key) {
                return false;
            }
        };
    }
}

