/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.publisher;

import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.UUID;
import javax.xml.ws.soap.SOAPFaultException;
import org.gcube.common.clients.stubs.jaxws.JAXWSUtils;
import org.gcube.common.resources.gcore.Resource;
import org.gcube.common.resources.gcore.ResourceMediator;
import org.gcube.common.resources.gcore.Resources;
import org.gcube.common.resources.gcore.ScopeGroup;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.informationsystem.publisher.RegistryPublisher;
import org.gcube.informationsystem.publisher.exception.RegistryNotFoundException;
import org.gcube.informationsystem.publisher.scope.ValidatorProvider;
import org.gcube.informationsystem.publisher.stubs.registry.RegistryStub;
import org.gcube.informationsystem.publisher.stubs.registry.faults.CreateException;
import org.gcube.informationsystem.publisher.stubs.registry.faults.InvalidResourceException;
import org.gcube.informationsystem.publisher.stubs.registry.faults.ResourceNotAcceptedException;
import org.gcube.informationsystem.publisher.stubs.registry.faults.UpdateException;
import org.gcube.informationsystem.publisher.utils.RegistryStubs;
import org.gcube.informationsystem.publisher.utils.ValidationUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegistryPublisherImpl
implements RegistryPublisher {
    private static final Logger log = LoggerFactory.getLogger(RegistryPublisher.class);
    private static final int REGISTRY_THRESHOLD = 5;
    private RegistryStubs registry = new RegistryStubs();
    private String scopeCreated;

    protected RegistryPublisherImpl() {
    }

    @Override
    public <T extends Resource> T create(T resource) {
        log.trace("registry-publisher: create method");
        String scope = ScopeProvider.instance.get();
        ValidationUtils.valid("resource", resource);
        ValidationUtils.valid("scopes", scope);
        if (ValidationUtils.isPresent(resource, scope)) {
            throw new IllegalStateException("The scope " + scope + " is already present in the resource. The create operation can't be performed ");
        }
        log.debug("resource id found: " + resource.id());
        if (resource.id() == null || resource.id().isEmpty()) {
            String id = UUID.randomUUID().toString();
            log.debug("id generated: " + id);
            ResourceMediator.setId(resource, id);
        }
        log.debug("scope setted in resource: " + scope);
        ResourceMediator.setScope(resource, scope);
        ValidatorProvider.getValidator(resource).checkScopeCompatibility(resource, Arrays.asList(scope));
        String type = resource.type().toString();
        try {
            Resources.validate(resource);
        }
        catch (Exception e) {
            log.error("the resource is not valid", (Throwable)e);
            throw new IllegalArgumentException("the resource is not valid ", e.getCause());
        }
        RegistryStub stub = this.getRegistryStub();
        this.createResource(resource, scope, stub);
        this.scopeCreated = scope;
        resource = this.update(resource);
        return resource;
    }

    @Override
    public <T extends Resource> T update(T resource) {
        log.trace(" update resource with id : " + resource.id());
        String currentScope = ScopeProvider.instance.get();
        ValidationUtils.valid("resource", resource);
        this.validateScope(resource);
        try {
            Resources.validate(resource);
        }
        catch (Exception e) {
            log.error("the resource is not valid", (Throwable)e);
            throw new IllegalArgumentException("the resource is not valid", e);
        }
        ScopeGroup scopes = resource.scopes();
        int tries = 0;
        for (String scope : scopes) {
            log.debug(" check update operation on scope " + scope);
            if (this.scopeCreated == null || this.scopeCreated != null && !this.scopeCreated.equals(scope)) {
                log.info("update operation: updating resource" + resource.id() + " on scope: " + scope);
                ScopeProvider.instance.set(scope);
                this.registryUpdate(resource, tries);
                tries = 0;
                continue;
            }
            log.trace("skip updating on scope " + this.scopeCreated);
        }
        this.scopeCreated = null;
        ScopeProvider.instance.set(currentScope);
        return resource;
    }

    @Override
    public <T extends Resource> T remove(T resource) {
        String currentScope = ScopeProvider.instance.get();
        log.info(" remove resource with id : " + resource.id() + " from scope: " + currentScope);
        ValidationUtils.valid("resource", resource);
        ValidationUtils.valid("scopes", currentScope);
        this.validateScope(resource);
        try {
            Resources.validate(resource);
        }
        catch (Exception e) {
            log.error("the resource is not valid", (Throwable)e);
            throw new IllegalArgumentException("the resource is not valid", e);
        }
        log.info(" remove " + currentScope + " scope from resource " + resource.id());
        ResourceMediator.removeScope(resource, currentScope);
        try {
            this.updateResourceRemoveOperation(resource, currentScope);
        }
        catch (Exception e) {
            ResourceMediator.setScope(resource, currentScope);
            log.error("exception message: " + e.getMessage());
            throw new RuntimeException(e.getMessage());
        }
        return resource;
    }

    private void registryUpdate(Resource resource, int tries) {
        log.trace("try to update resource with id: " + resource.id() + " times " + (tries + 1) + " on scope: " + ScopeProvider.instance.get());
        try {
            this.registry.getStubs().update(resource.id(), resource.type().toString(), this.toXml(resource));
        }
        catch (RegistryNotFoundException e) {
            throw new IllegalArgumentException(e.getCause());
        }
        catch (InvalidResourceException e) {
            throw new IllegalArgumentException(e.getCause());
        }
        catch (ResourceNotAcceptedException e) {
            throw new IllegalArgumentException(e.getCause());
        }
        catch (UpdateException e) {
            throw new IllegalArgumentException(e.getCause());
        }
        catch (SOAPFaultException e) {
            log.warn("Failed update resource on " + this.registry.getEndPoints().get(0) + " times: " + (tries + 1));
            if (tries < 5) {
                ++tries;
                try {
                    Thread.sleep(3000L);
                }
                catch (InterruptedException e1) {
                    e1.printStackTrace();
                }
                this.registryUpdate(resource, tries);
            }
            throw new IllegalArgumentException(JAXWSUtils.remoteCause((SOAPFaultException)e));
        }
    }

    private String toXml(Resource resource) {
        StringWriter writer = new StringWriter();
        Resources.marshal((Object)resource, (Writer)writer);
        return writer.toString();
    }

    private void validateScope(Resource resource) {
        ValidatorProvider.getValidator(resource).validate(resource);
    }

    private <T extends Resource> void updateResourceRemoveOperation(T resource, String currentScope) {
        if (!this.isRemoveNeeded(resource, currentScope)) {
            this.updateResource(resource, currentScope);
        } else {
            log.info("the resource have only the " + currentScope + " scope defined. Remove the resource " + resource.id() + " from IC");
            try {
                log.debug("remove from IS scope " + currentScope);
                this.registry.getStubs().remove(resource.id(), resource.type().toString());
            }
            catch (Exception e) {
                log.error("the resource can't be removed ", (Throwable)e);
                throw new IllegalArgumentException("the resource can't be removed from scope " + currentScope, e);
            }
            this.updateResource(resource, currentScope);
        }
    }

    private <T extends Resource> boolean isRemoveNeeded(T resource, String scope) {
        return ValidationUtils.isCompatibleScopeForRemove(resource, scope);
    }

    private <T extends Resource> void createResource(T resource, String scope, RegistryStub stub) {
        try {
            log.info("create resource with id " + resource.id() + " in scope: " + scope);
            String type = null;
            type = resource.type().toString();
            log.info("resource type is: " + type);
            if (resource.type().equals((Object)"ServiceEndpoint")) {
                type = "RuntimeResource";
            }
            stub.create(this.toXml(resource), type);
        }
        catch (InvalidResourceException e) {
            throw new IllegalArgumentException(e.getCause());
        }
        catch (ResourceNotAcceptedException e) {
            throw new IllegalArgumentException(e.getCause());
        }
        catch (CreateException e) {
            throw new IllegalArgumentException(e.getCause());
        }
        catch (SOAPFaultException e) {
            throw new IllegalArgumentException(JAXWSUtils.remoteCause((SOAPFaultException)e));
        }
        log.info("created resource " + resource.id() + " on scope " + scope);
    }

    private RegistryStub getRegistryStub() {
        RegistryStub stub = null;
        try {
            stub = this.registry.getStubs();
        }
        catch (RegistryNotFoundException e) {
            throw new IllegalArgumentException(e.getCause());
        }
        return stub;
    }

    private <T extends Resource> void updateResource(T resource, String currentScope) {
        ScopeGroup scopes = resource.scopes();
        int tries = 0;
        for (String scope : scopes) {
            ScopeProvider.instance.set(scope);
            this.registryUpdate(resource, tries);
        }
        ScopeProvider.instance.set(currentScope);
    }
}

