/*
 * Decompiled with CFR 0.152.
 */
package org.jamwiki.migrate;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.jamwiki.DataAccessException;
import org.jamwiki.WikiBase;
import org.jamwiki.WikiException;
import org.jamwiki.WikiMessage;
import org.jamwiki.migrate.MediaWikiXmlExporter;
import org.jamwiki.migrate.MediaWikiXmlImporter;
import org.jamwiki.migrate.MigrationException;
import org.jamwiki.model.Topic;
import org.jamwiki.model.TopicType;
import org.jamwiki.model.TopicVersion;
import org.jamwiki.model.WikiUser;
import org.jamwiki.parser.ParserException;
import org.jamwiki.parser.ParserOutput;
import org.jamwiki.parser.ParserUtil;
import org.jamwiki.utils.Utilities;
import org.jamwiki.utils.WikiLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MigrationUtil {
    private static final WikiLogger logger = WikiLogger.getLogger(MigrationUtil.class.getName());

    public static void exportToFile(File file, String virtualWiki, List<String> topicNames, boolean excludeHistory) throws MigrationException, WikiException {
        MediaWikiXmlExporter exporter = new MediaWikiXmlExporter();
        exporter.exportToFile(file, virtualWiki, topicNames, excludeHistory);
    }

    public static List<String> importFromFile(File file, String virtualWiki, WikiUser user, String authorDisplay, Locale locale) throws MigrationException, WikiException {
        MediaWikiXmlImporter importer = new MediaWikiXmlImporter();
        long start = System.currentTimeMillis();
        Map<Topic, List<Integer>> parsedTopics = null;
        try {
            parsedTopics = importer.importFromFile(file, virtualWiki);
        }
        catch (MigrationException e) {
            if (e.getCause() instanceof WikiException) {
                throw (WikiException)e.getCause();
            }
            throw e;
        }
        logger.debug("Parsed XML " + file.getAbsolutePath() + " in " + (double)(System.currentTimeMillis() - start) / 1000.0 + " s.");
        if (parsedTopics.isEmpty()) {
            throw new WikiException(new WikiMessage("import.error.notopic"));
        }
        ArrayList<String> successfulImports = new ArrayList<String>();
        for (Topic topic : parsedTopics.keySet()) {
            String importedBy = user != null && user.getUserId() > 0 ? user.getUsername() : authorDisplay;
            String editComment = Utilities.formatMessage("import.message.importedby", locale, new Object[]{importedBy});
            TopicVersion topicVersion = new TopicVersion(user, authorDisplay, editComment, topic.getTopicContent(), 0);
            topicVersion.setEditType(8);
            ParserOutput parserOutput = null;
            try {
                parserOutput = ParserUtil.parserOutput(topicVersion.getVersionContent(), virtualWiki, topic.getName());
            }
            catch (ParserException e) {
                throw new MigrationException("Failure while parsing topic version of topic: " + topic.getName(), e);
            }
            if (!StringUtils.isBlank((String)parserOutput.getRedirect())) {
                topic.setRedirectTo(parserOutput.getRedirect());
                topic.setTopicType(TopicType.REDIRECT);
            }
            try {
                WikiBase.getDataHandler().writeTopic(topic, topicVersion, parserOutput.getCategories(), parserOutput.getLinks());
            }
            catch (DataAccessException e) {
                throw new MigrationException("Data access exception while processing topic " + topic.getName(), e);
            }
            successfulImports.add(topic.getName());
        }
        return successfulImports;
    }
}

