/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.jgroups.Address;
import org.jgroups.ChannelListener;
import org.jgroups.Event;
import org.jgroups.Message;
import org.jgroups.Receiver;
import org.jgroups.UpHandler;
import org.jgroups.View;
import org.jgroups.annotations.MBean;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.logging.Log;
import org.jgroups.stack.Protocol;
import org.jgroups.stack.ProtocolStack;
import org.jgroups.util.DefaultSocketFactory;
import org.jgroups.util.SocketFactory;

@MBean(description="Channel")
public abstract class Channel {
    protected volatile State state = State.OPEN;
    protected UpHandler up_handler = null;
    protected Set<ChannelListener> channel_listeners = null;
    protected Receiver receiver = null;
    protected SocketFactory socket_factory = new DefaultSocketFactory();
    @ManagedAttribute(description="Whether or not to discard messages sent by this channel", writable=true)
    protected boolean discard_own_messages = false;

    @ManagedAttribute(description="The current state")
    public String getState() {
        return this.state.toString();
    }

    protected abstract Log getLog();

    public abstract ProtocolStack getProtocolStack();

    public SocketFactory getSocketFactory() {
        return this.socket_factory;
    }

    public void setSocketFactory(SocketFactory factory) {
        Protocol prot;
        this.socket_factory = factory;
        ProtocolStack stack = this.getProtocolStack();
        Protocol protocol = prot = stack != null ? stack.getTopProtocol() : null;
        if (prot != null) {
            prot.setSocketFactory(factory);
        }
    }

    public abstract void connect(String var1) throws Exception;

    public abstract void connect(String var1, Address var2, long var3) throws Exception;

    public abstract void disconnect();

    public abstract void close();

    @ManagedAttribute
    public boolean isOpen() {
        return this.state != State.CLOSED;
    }

    @ManagedAttribute
    public boolean isConnected() {
        return this.state == State.CONNECTED;
    }

    @ManagedAttribute
    public boolean isConnecting() {
        return this.state == State.CONNECTING;
    }

    @ManagedAttribute
    public boolean isClosed() {
        return this.state == State.CLOSED;
    }

    public abstract Map<String, Object> dumpStats();

    public abstract void send(Message var1) throws Exception;

    public abstract void send(Address var1, Object var2) throws Exception;

    public abstract void send(Address var1, byte[] var2) throws Exception;

    public abstract void send(Address var1, byte[] var2, int var3, int var4) throws Exception;

    public Object down(Event evt) {
        return null;
    }

    public abstract View getView();

    public abstract Address getAddress();

    public abstract String getName();

    public abstract String getName(Address var1);

    public abstract void setName(String var1);

    public abstract String getClusterName();

    public String getProperties() {
        return "n/a";
    }

    public void setUpHandler(UpHandler up_handler) {
        this.up_handler = up_handler;
    }

    public UpHandler getUpHandler() {
        return this.up_handler;
    }

    public synchronized void addChannelListener(ChannelListener listener) {
        if (listener == null) {
            return;
        }
        if (this.channel_listeners == null) {
            this.channel_listeners = new CopyOnWriteArraySet<ChannelListener>();
        }
        this.channel_listeners.add(listener);
    }

    public synchronized void removeChannelListener(ChannelListener listener) {
        if (this.channel_listeners != null && listener != null) {
            this.channel_listeners.remove(listener);
        }
    }

    public synchronized void clearChannelListeners() {
        if (this.channel_listeners != null) {
            this.channel_listeners.clear();
        }
    }

    public void setReceiver(Receiver r) {
        this.receiver = r;
    }

    public Receiver getReceiver() {
        return this.receiver;
    }

    public void setDiscardOwnMessages(boolean flag) {
        this.discard_own_messages = flag;
    }

    public boolean getDiscardOwnMessages() {
        return this.discard_own_messages;
    }

    public abstract boolean flushSupported();

    public abstract void startFlush(List<Address> var1, boolean var2) throws Exception;

    public abstract void startFlush(boolean var1) throws Exception;

    public abstract void stopFlush();

    public abstract void stopFlush(List<Address> var1);

    public abstract void getState(Address var1, long var2) throws Exception;

    protected void notifyChannelConnected(Channel c) {
        if (this.channel_listeners == null) {
            return;
        }
        for (ChannelListener channelListener : this.channel_listeners) {
            try {
                channelListener.channelConnected(c);
            }
            catch (Throwable t) {
                this.getLog().error("exception in channelConnected() callback", t);
            }
        }
    }

    protected void notifyChannelDisconnected(Channel c) {
        if (this.channel_listeners == null) {
            return;
        }
        for (ChannelListener channelListener : this.channel_listeners) {
            try {
                channelListener.channelDisconnected(c);
            }
            catch (Throwable t) {
                this.getLog().error("exception in channelDisonnected() callback", t);
            }
        }
    }

    protected void notifyChannelClosed(Channel c) {
        if (this.channel_listeners == null) {
            return;
        }
        for (ChannelListener channelListener : this.channel_listeners) {
            try {
                channelListener.channelClosed(c);
            }
            catch (Throwable t) {
                this.getLog().error("exception in channelClosed() callback", t);
            }
        }
    }

    public static enum State {
        OPEN,
        CONNECTING,
        CONNECTED,
        CLOSED;

    }
}

