/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.streams;

import gr.uoa.di.madgik.commons.server.ITCPConnectionManagerEntry;
import gr.uoa.di.madgik.commons.server.TCPConnectionManager;
import gr.uoa.di.madgik.commons.server.TCPConnectionManagerConfig;
import gr.uoa.di.madgik.grs.proxy.tcp.TCPConnectionHandler;
import java.net.InetAddress;
import java.util.ArrayList;
import org.gcube.data.streams.exceptions.StreamContingency;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utils {
    private static Logger log = LoggerFactory.getLogger(Utils.class);

    public static synchronized void initialiseRS() {
        if (TCPConnectionManager.IsInitialized()) {
            return;
        }
        log.info("gRS2 is not initialised: using defaults");
        String host = null;
        try {
            host = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception e) {
            log.info("could not discover hostname, using 'localhost' to allow offline usage");
            host = "localhost";
        }
        try {
            TCPConnectionManager.Init((TCPConnectionManagerConfig)new TCPConnectionManagerConfig(host, new ArrayList(), true));
            TCPConnectionManager.RegisterEntry((ITCPConnectionManagerEntry)new TCPConnectionHandler());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean isContingency(Throwable t) {
        return t.getClass().isAnnotationPresent(StreamContingency.class) || t.getCause() != null && Utils.isContingency(t.getCause());
    }
}

