/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.streams.dsl.publish;

import java.net.URI;
import java.util.concurrent.TimeUnit;
import org.gcube.data.streams.dsl.StreamClause;
import org.gcube.data.streams.dsl.publish.PublishRsEnv;
import org.gcube.data.streams.handlers.FaultHandler;
import org.gcube.data.streams.publishers.RsPublisher;
import org.gcube.data.streams.publishers.ThreadProvider;

public class PublishRsWithClause<E>
extends StreamClause<E, PublishRsEnv<E>> {
    private final RsPublisher<E> publisher;

    public PublishRsWithClause(PublishRsEnv<E> e) {
        super(e);
        this.publisher = new RsPublisher(e.stream(), e.factory);
    }

    public PublishRsWithClause<E> withBufferOf(int size) {
        this.publisher.setBufferSize(size);
        return this;
    }

    public PublishRsWithClause<E> withTimeoutOf(int timeout, TimeUnit unit) {
        this.publisher.setTimeout(timeout, unit);
        return this;
    }

    public PublishRsWithClause<E> nonstop() {
        this.publisher.setOnDemand(false);
        return this;
    }

    public PublishRsWithClause<E> with(ThreadProvider provider) {
        this.publisher.setThreadProvider(provider);
        return this;
    }

    public URI with(FaultHandler handler) {
        this.publisher.setFaultHandler(handler);
        return this.publisher.publish();
    }

    public URI withDefaults() {
        return this.publisher.publish();
    }
}

