/*
 * Decompiled with CFR 0.152.
 */
package rath.msnm.ftp;

import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import rath.msnm.MSNMessenger;
import rath.msnm.ftp.VolatileTransfer;
import rath.msnm.msg.MimeMessage;

public class VolatileDownloader
extends Thread
implements VolatileTransfer {
    String cookie = null;
    private final MSNMessenger msn;
    private boolean isLive = true;
    private String host = null;
    private int port;
    private String authCookie = null;
    private String loginName = null;
    private File file = null;
    private int filesize = -1;
    private volatile int offset;
    private Socket socket = null;
    private InputStream rawIn = null;
    private InputStreamReader in = null;
    private PrintWriter out = null;

    private VolatileDownloader(MSNMessenger msn) {
        this.msn = msn;
    }

    public static VolatileDownloader getInstance(MSNMessenger msn, File toReceive, MimeMessage msg) {
        String host = msg.getProperty("IP-Address");
        int port = Integer.parseInt(msg.getProperty("Port"));
        String authCookie = msg.getProperty("AuthCookie");
        String loginName = msn.getLoginName();
        if (host == null || authCookie == null) {
            throw new IllegalArgumentException("Insufficient mime property");
        }
        VolatileDownloader vd = new VolatileDownloader(msn);
        vd.host = host;
        vd.port = port;
        vd.authCookie = authCookie;
        vd.loginName = loginName;
        vd.file = toReceive;
        return vd;
    }

    public String getHostAddress() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getAuthCookie() {
        return this.authCookie;
    }

    public String getCookie() {
        return this.cookie;
    }

    public File getFile() {
        return this.file;
    }

    public String getFilename() {
        return this.file.getName();
    }

    public int getCurrentFileSize() {
        return this.offset;
    }

    public int getCommitPercent() {
        return (int)((double)this.offset / (double)this.filesize * 100.0);
    }

    public int getFileSize() {
        return this.filesize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void run() {
        try {
            this.fireStart();
            this.makeConnection();
            this.sendMessage("VER", "MSNFTP");
            while (this.isLive) {
                String line = this.readLine();
                if (line == null) {
                    break;
                }
                String header = line.substring(0, 3);
                String body = "";
                if (line.length() > 4) {
                    body = line.substring(4);
                }
                this.processMessage(header, body);
            }
        }
        catch (Throwable e) {
            this.fireError(e);
        }
        finally {
            this.close();
        }
    }

    private String readLine() throws IOException {
        int buf;
        CharArrayWriter caw = new CharArrayWriter(40);
        while ((buf = this.in.read()) != -1) {
            if (buf == 13) continue;
            if (buf == 10) {
                return caw.toString();
            }
            caw.write(buf);
        }
        if (caw.size() != 0) {
            return caw.toString();
        }
        return null;
    }

    public void processMessage(String header, String body) throws Throwable {
        if (header.equals("VER")) {
            this.sendMessage("USR", this.loginName + " " + this.authCookie);
        } else if (header.equals("FIL")) {
            this.filesize = Integer.parseInt(body);
            this.sendMessage("TFR");
            this.getFileContent();
            this.sendMessage("BYE", "16777989");
            this.isLive = false;
        }
    }

    public void sendMessage(String header) throws IOException {
        StringBuffer sb = new StringBuffer(6);
        sb.append(header);
        sb.append("\r\n");
        this.out.print(sb.toString());
        this.out.flush();
    }

    public void sendMessage(String header, String body) throws IOException {
        StringBuffer sb = new StringBuffer(64);
        sb.append(header);
        sb.append(' ');
        sb.append(body);
        sb.append("\r\n");
        this.out.print(sb.toString());
        this.out.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getFileContent() throws IOException {
        byte[] buf = new byte[2045];
        FileOutputStream fos = new FileOutputStream(this.file);
        try {
            do {
                int block;
                int pad = this.rawIn.read();
                int size = this.rawIn.read() | this.rawIn.read() << 8;
                if (size == 0) {
                    break;
                }
                int readlen = 0;
                while ((block = this.rawIn.read(buf, readlen, size - readlen)) != -1 && (readlen += block) != size) {
                }
                if (readlen != size) {
                    throw new IOException("stream closed");
                }
                this.offset += readlen;
                fos.write(buf, 0, readlen);
                fos.flush();
            } while (this.offset < this.filesize);
        }
        finally {
            try {
                fos.close();
            }
            catch (IOException iOException) {}
        }
    }

    public void close() {
        this.isLive = false;
        if (this.in != null) {
            try {
                this.in.close();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (this.out != null) {
            try {
                this.out.close();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void fireStart() {
        this.msn.fireFileReceiveStartedEvent(this);
    }

    protected void fireError(Throwable e) {
        this.msn.fireFileReceiveErrorEvent(this, e);
    }

    protected void makeConnection() throws IOException {
        this.socket = new Socket(this.host, this.port);
        this.rawIn = this.socket.getInputStream();
        this.in = new InputStreamReader(this.rawIn);
        this.out = new PrintWriter(this.socket.getOutputStream());
    }
}

