/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.deploy.sandbox;

import com.liferay.portal.kernel.deploy.sandbox.SandboxDeployListener;
import com.liferay.portal.kernel.deploy.sandbox.SandboxDeployScanner;
import com.liferay.portal.kernel.io.DirectoryFilter;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.ListUtil;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class SandboxDeployDir {
    public static final String DEFAULT_NAME = "defaultSandboxDeployDir";
    private static Log _log = LogFactoryUtil.getLog(SandboxDeployDir.class);
    private File _deployDir;
    private DirectoryFilter _directoryFilter = new DirectoryFilter();
    private List<File> _existingDirs;
    private long _interval;
    private String _name;
    private List<SandboxDeployListener> _sandboxDeployListeners;
    private SandboxDeployScanner _sandboxDeployScanner;

    public SandboxDeployDir(String name, File deployDir, long interval, List<SandboxDeployListener> sandboxDeployListeners) {
        this._name = name;
        this._deployDir = deployDir;
        this._interval = interval;
        this._sandboxDeployListeners = new CopyOnWriteArrayList<SandboxDeployListener>(sandboxDeployListeners);
    }

    public File getDeployDir() {
        return this._deployDir;
    }

    public long getInterval() {
        return this._interval;
    }

    public List<SandboxDeployListener> getListeners() {
        return this._sandboxDeployListeners;
    }

    public String getName() {
        return this._name;
    }

    public void registerListener(SandboxDeployListener listener) {
        this._sandboxDeployListeners.add(listener);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void start() {
        if (!this._deployDir.exists()) {
            boolean created;
            if (_log.isInfoEnabled()) {
                _log.info("Creating missing directory " + this._deployDir);
            }
            if (!(created = this._deployDir.mkdirs())) {
                _log.error("Directory " + this._deployDir + " could not be created");
            }
        }
        if (this._interval > 0L) {
            this._existingDirs = ListUtil.fromArray(this._deployDir.listFiles(this._directoryFilter));
            Iterator<File> itr = this._existingDirs.iterator();
            while (itr.hasNext()) {
                File dir = itr.next();
                if (FileUtil.exists(dir + "/WEB-INF/web.xml")) continue;
                itr.remove();
            }
            try {
                Thread currentThread = Thread.currentThread();
                this._sandboxDeployScanner = new SandboxDeployScanner(currentThread.getThreadGroup(), SandboxDeployScanner.class.getName(), this);
                this._sandboxDeployScanner.start();
                if (!_log.isInfoEnabled()) return;
                _log.info("Sandbox deploy scanner started for " + this._deployDir);
                return;
            }
            catch (Exception e) {
                _log.error(e, e);
                this.stop();
                return;
            }
        } else {
            if (!_log.isInfoEnabled()) return;
            _log.info("Sandbox deploy scanning is disabled for " + this._deployDir);
        }
    }

    public void stop() {
        if (this._sandboxDeployScanner != null) {
            this._sandboxDeployScanner.pause();
        }
    }

    public void unregisterListener(SandboxDeployListener sandboxDeployListener) {
        this._sandboxDeployListeners.remove(sandboxDeployListener);
    }

    protected void deployDir(File file) {
        String fileName = file.getName();
        if (!file.canRead()) {
            _log.error("Unable to read " + fileName);
            return;
        }
        if (!file.canWrite()) {
            _log.error("Unable to write " + fileName);
            return;
        }
        if (_log.isInfoEnabled()) {
            _log.info("Processing " + fileName);
        }
        try {
            for (SandboxDeployListener sandboxDeployListener : this._sandboxDeployListeners) {
                sandboxDeployListener.deploy(file);
            }
        }
        catch (Exception e) {
            _log.error(e, e);
        }
    }

    protected void scanDirectory() {
        File[] currentDirs = this._deployDir.listFiles(this._directoryFilter);
        if (currentDirs.length != this._existingDirs.size()) {
            File[] fileArray = currentDirs;
            int n = currentDirs.length;
            int n2 = 0;
            while (n2 < n) {
                File dir = fileArray[n2];
                if (!this._existingDirs.contains(dir)) {
                    this._existingDirs.add(dir);
                    this.deployDir(dir);
                }
                ++n2;
            }
        }
        Iterator<File> itr = this._existingDirs.iterator();
        while (itr.hasNext()) {
            File dir = itr.next();
            if (dir.exists()) continue;
            itr.remove();
            this.undeployDir(dir);
        }
    }

    protected void undeployDir(File file) {
        try {
            for (SandboxDeployListener sandboxDeployListener : this._sandboxDeployListeners) {
                sandboxDeployListener.undeploy(file);
            }
        }
        catch (Exception e) {
            _log.error(e, e);
        }
    }
}

