/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.search.facet.config;

import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.facet.config.FacetConfiguration;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import java.util.List;

public class FacetConfigurationUtil {
    private static Log _log = LogFactoryUtil.getLog(FacetConfigurationUtil.class);

    public static List<FacetConfiguration> load(String configuration) {
        ArrayList<FacetConfiguration> facetConfigurations = new ArrayList<FacetConfiguration>();
        try {
            if (Validator.isNull(configuration)) {
                return facetConfigurations;
            }
            JSONObject configurationJSONObject = JSONFactoryUtil.createJSONObject(configuration);
            JSONArray facetsJSONArray = configurationJSONObject.getJSONArray("facets");
            if (facetsJSONArray == null) {
                return facetConfigurations;
            }
            int i = 0;
            while (i < facetsJSONArray.length()) {
                JSONObject facetJSONObject = facetsJSONArray.getJSONObject(i);
                FacetConfiguration facetConfiguration = FacetConfigurationUtil._toFacetConfiguration(facetJSONObject);
                facetConfigurations.add(facetConfiguration);
                ++i;
            }
        }
        catch (Exception e) {
            _log.error(e, e);
        }
        return facetConfigurations;
    }

    private static FacetConfiguration _toFacetConfiguration(JSONObject facetJSONObject) {
        FacetConfiguration facetConfiguration = new FacetConfiguration();
        facetConfiguration.setClassName(facetJSONObject.getString("className"));
        if (facetJSONObject.has("data")) {
            facetConfiguration.setDataJSONObject(facetJSONObject.getJSONObject("data"));
        }
        facetConfiguration.setDisplayStyle(facetJSONObject.getString("displayStyle"));
        facetConfiguration.setFieldName(facetJSONObject.getString("fieldName"));
        facetConfiguration.setLabel(facetJSONObject.getString("label"));
        facetConfiguration.setOrder(facetJSONObject.getString("order"));
        facetConfiguration.setStatic(facetJSONObject.getBoolean("static"));
        facetConfiguration.setWeight(facetJSONObject.getDouble("weight"));
        return facetConfiguration;
    }
}

