/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.portal.kernel.util.AutoResetThreadLocal;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class CharBufferPool {
    private static final int _INITIAL_POOL_SIZE = 50;
    private static final int _MAX_POOL_SIZE = 100;
    private static ThreadLocal<List<CharBufferHolder>> _borrowedCharBufferHoldersThreadLocal = new AutoResetThreadLocal(String.valueOf(CharBufferPool.class.getName()) + "._borrowedCharBufferHoldersThreadLocal", new ArrayList());
    private static List<CharBufferHolder> _charBufferHoldersPool = new ArrayList<CharBufferHolder>(50);
    private static ThreadLocal<Boolean> _enabledThreadLocal = new AutoResetThreadLocal<Boolean>(String.valueOf(CharBufferPool.class.getName()) + "._enabledThreadLocal", false);
    private static Lock _modifyLock = new ReentrantLock();
    private static ReferenceQueue<Object> _referenceQueue = new ReferenceQueue();

    public static char[] borrow(int size) {
        CharBufferHolder charBufferHolder;
        if (!CharBufferPool.isEnabled()) {
            return new char[size];
        }
        CharBufferPool._cleanUpDeadBuffers();
        int poolSize = -1;
        _modifyLock.lock();
        try {
            int index = Collections.binarySearch(_charBufferHoldersPool, new CharBufferHolder(size));
            if (index < 0) {
                index = -(index + 1);
            }
            while (index < _charBufferHoldersPool.size()) {
                charBufferHolder = _charBufferHoldersPool.get(index);
                if (charBufferHolder._borrowed) {
                    ++index;
                    continue;
                }
                char[] charBuffer = (char[])charBufferHolder.get();
                if (charBuffer != null) {
                    charBufferHolder._borrowed = true;
                    List<CharBufferHolder> borrowedCharBufferHolders = _borrowedCharBufferHoldersThreadLocal.get();
                    borrowedCharBufferHolders.add(charBufferHolder);
                    char[] cArray = charBuffer;
                    return cArray;
                }
                _charBufferHoldersPool.remove(index);
            }
        }
        finally {
            poolSize = _charBufferHoldersPool.size();
            _modifyLock.unlock();
        }
        char[] charBuffer = new char[size + (size >> 9)];
        if (poolSize < 100) {
            charBufferHolder = new CharBufferHolder(charBuffer);
            List<CharBufferHolder> borrowedCharBufferHolders = _borrowedCharBufferHoldersThreadLocal.get();
            borrowedCharBufferHolders.add(charBufferHolder);
        }
        return charBuffer;
    }

    public static void cleanUp() {
        List<CharBufferHolder> charBufferHolders = _borrowedCharBufferHoldersThreadLocal.get();
        _modifyLock.lock();
        try {
            for (CharBufferHolder charBufferHolder : charBufferHolders) {
                if (charBufferHolder._borrowed) {
                    charBufferHolder._borrowed = false;
                    continue;
                }
                int index = Collections.binarySearch(_charBufferHoldersPool, charBufferHolder);
                if (index < 0) {
                    index = -(index + 1);
                }
                _charBufferHoldersPool.add(index, charBufferHolder);
            }
        }
        finally {
            _modifyLock.unlock();
        }
        charBufferHolders.clear();
        CharBufferPool._cleanUpDeadBuffers();
    }

    public static boolean isEnabled() {
        return _enabledThreadLocal.get();
    }

    public static void setEnabled(boolean enabled) {
        _enabledThreadLocal.set(enabled);
    }

    private static void _cleanUpDeadBuffers() {
        CharBufferHolder charBufferHolder = (CharBufferHolder)_referenceQueue.poll();
        if (charBufferHolder == null) {
            return;
        }
        _modifyLock.lock();
        try {
            do {
                _charBufferHoldersPool.remove(charBufferHolder);
            } while ((charBufferHolder = (CharBufferHolder)_referenceQueue.poll()) != null);
        }
        finally {
            _modifyLock.unlock();
        }
    }

    private static class CharBufferHolder
    extends SoftReference<char[]>
    implements Comparable<CharBufferHolder> {
        private boolean _borrowed;
        private int _length;

        public CharBufferHolder(char[] charBuffer) {
            super(charBuffer, _referenceQueue);
            this._length = charBuffer.length;
        }

        public CharBufferHolder(int length) {
            super(null);
            this._length = length;
        }

        @Override
        public int compareTo(CharBufferHolder charBufferHolder) {
            return this._length - charBufferHolder._length;
        }
    }
}

