/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ReflectionUtil;
import com.liferay.portal.kernel.util.ThreadUtil;
import java.lang.ref.Reference;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class ClearThreadLocalUtil {
    private static Log _log;
    private static Method _expungeStaleEntriesMethod;
    private static Field _inheritableThreadLocalsField;
    private static boolean _initialized;
    private static Method _removeMethod;
    private static Field _tableField;
    private static Field _threadLocalsField;
    private static Field _valueField;

    static {
        block2: {
            _log = LogFactoryUtil.getLog(ClearThreadLocalUtil.class);
            try {
                _inheritableThreadLocalsField = ReflectionUtil.getDeclaredField(Thread.class, "inheritableThreadLocals");
                _threadLocalsField = ReflectionUtil.getDeclaredField(Thread.class, "threadLocals");
                Class<?> threadLocalMapClass = Class.forName("java.lang.ThreadLocal$ThreadLocalMap");
                _expungeStaleEntriesMethod = ReflectionUtil.getDeclaredMethod(threadLocalMapClass, "expungeStaleEntries", new Class[0]);
                _removeMethod = ReflectionUtil.getDeclaredMethod(threadLocalMapClass, "remove", ThreadLocal.class);
                _tableField = ReflectionUtil.getDeclaredField(threadLocalMapClass, "table");
                Class<?> threadLocalMapEntryClass = Class.forName("java.lang.ThreadLocal$ThreadLocalMap$Entry");
                _valueField = ReflectionUtil.getDeclaredField(threadLocalMapEntryClass, "value");
                _initialized = true;
            }
            catch (Throwable t) {
                _initialized = false;
                if (!_log.isWarnEnabled()) break block2;
                _log.warn("Failed to initialize ClearThreadLocalUtil", t);
            }
        }
    }

    public static void clearThreadLocal() throws Exception {
        if (!_initialized) {
            return;
        }
        Thread[] threads = ThreadUtil.getThreads();
        Thread currentThread = Thread.currentThread();
        ClassLoader contextClassLoader = currentThread.getContextClassLoader();
        Thread[] threadArray = threads;
        int n = threads.length;
        int n2 = 0;
        while (n2 < n) {
            Thread thread = threadArray[n2];
            ClearThreadLocalUtil._clearThreadLocal(thread, contextClassLoader);
            ++n2;
        }
    }

    private static void _clearThreadLocal(Thread thread, ClassLoader classLoader) throws Exception {
        if (thread == null) {
            return;
        }
        Object threadLocalMap = _threadLocalsField.get(thread);
        Object inheritableThreadLocalMap = _inheritableThreadLocalsField.get(thread);
        ClearThreadLocalUtil._clearThreadLocalMap(threadLocalMap, classLoader);
        ClearThreadLocalUtil._clearThreadLocalMap(inheritableThreadLocalMap, classLoader);
    }

    private static void _clearThreadLocalMap(Object threadLocalMap, ClassLoader classLoader) throws Exception {
        if (threadLocalMap == null) {
            return;
        }
        Object[] table = (Object[])_tableField.get(threadLocalMap);
        if (table == null) {
            return;
        }
        int staleEntriesCount = 0;
        Object[] objectArray = table;
        int n = table.length;
        int n2 = 0;
        while (n2 < n) {
            Object tableEntry = objectArray[n2];
            if (tableEntry != null) {
                Class<?> valueClass;
                ClassLoader valueClassLoader;
                Class<?> keyClass;
                ClassLoader keyClassLoader;
                Object key = ((Reference)tableEntry).get();
                Object value = _valueField.get(tableEntry);
                boolean remove = false;
                if (key != null && (keyClassLoader = (keyClass = key.getClass()).getClassLoader()) == classLoader) {
                    remove = true;
                }
                if (value != null && (valueClassLoader = (valueClass = value.getClass()).getClassLoader()) == classLoader) {
                    remove = true;
                }
                if (remove) {
                    if (key != null) {
                        if (_log.isDebugEnabled()) {
                            keyClass = key.getClass();
                            _log.debug("Clear a ThreadLocal with key of type " + keyClass.getCanonicalName());
                        }
                        _removeMethod.invoke(threadLocalMap, key);
                    } else {
                        ++staleEntriesCount;
                    }
                }
            }
            ++n2;
        }
        if (staleEntriesCount > 0) {
            _expungeStaleEntriesMethod.invoke(threadLocalMap, new Object[0]);
        }
    }
}

