/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.portal.kernel.security.pacl.permission.PortalRuntimePermission;
import com.liferay.portal.kernel.util.TimeZoneThreadLocal;
import com.liferay.portal.kernel.util.Validator;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;

public class TimeZoneUtil {
    public static TimeZone GMT;
    private static TimeZoneUtil _instance;
    private TimeZone _timeZone;
    private Map<String, TimeZone> _timeZones = new HashMap<String, TimeZone>();

    static {
        _instance = new TimeZoneUtil();
        GMT = TimeZoneUtil.getTimeZone("GMT");
    }

    public static TimeZone getDefault() {
        return TimeZoneUtil.getInstance()._getDefault();
    }

    public static TimeZoneUtil getInstance() {
        PortalRuntimePermission.checkGetBeanProperty(TimeZoneUtil.class);
        return _instance;
    }

    public static TimeZone getTimeZone(String timeZoneId) {
        return TimeZoneUtil.getInstance()._getTimeZone(timeZoneId);
    }

    public static void setDefault(String timeZoneId) {
        TimeZoneUtil.getInstance()._setDefault(timeZoneId);
    }

    private TimeZoneUtil() {
        this._timeZone = this._getTimeZone("UTC");
    }

    private TimeZone _getDefault() {
        TimeZone timeZone = TimeZoneThreadLocal.getDefaultTimeZone();
        if (timeZone != null) {
            return timeZone;
        }
        return this._timeZone;
    }

    private TimeZone _getTimeZone(String timeZoneId) {
        TimeZone timeZone = this._timeZones.get(timeZoneId);
        if (timeZone == null) {
            timeZone = TimeZone.getTimeZone(timeZoneId);
            this._timeZones.put(timeZoneId, timeZone);
        }
        return timeZone;
    }

    private void _setDefault(String timeZoneId) {
        PortalRuntimePermission.checkSetBeanProperty(this.getClass());
        if (Validator.isNotNull(timeZoneId)) {
            this._timeZone = TimeZone.getTimeZone(timeZoneId);
        }
    }
}

