/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.webdav;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.pacl.permission.PortalRuntimePermission;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UniqueList;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.webdav.WebDAVException;
import com.liferay.portal.kernel.webdav.WebDAVStorage;
import com.liferay.portal.kernel.xml.Namespace;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.User;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.util.comparator.GroupFriendlyURLComparator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;

public class WebDAVUtil {
    public static final Namespace DAV_URI = SAXReaderUtil.createNamespace("D", "DAV:");
    public static final int SC_LOCKED = 423;
    public static final int SC_MULTI_STATUS = 207;
    public static final String TOKEN_PREFIX = "opaquelocktoken:";
    private static Log _log = LogFactoryUtil.getLog(WebDAVUtil.class);
    private static WebDAVUtil _instance = new WebDAVUtil();
    private Map<String, WebDAVStorage> _storageMap = new TreeMap<String, WebDAVStorage>();

    public static void addStorage(WebDAVStorage storage) {
        WebDAVUtil.getInstance()._addStorage(storage);
    }

    public static Namespace createNamespace(String prefix, String uri) {
        Namespace namespace = null;
        namespace = uri.equals(DAV_URI.getURI()) ? DAV_URI : (Validator.isNull(prefix) ? SAXReaderUtil.createNamespace(uri) : SAXReaderUtil.createNamespace(prefix, uri));
        return namespace;
    }

    public static void deleteStorage(WebDAVStorage storage) {
        WebDAVUtil.getInstance()._deleteStorage(storage);
    }

    public static long getDepth(HttpServletRequest request) {
        String value = GetterUtil.getString(request.getHeader("Depth"));
        if (_log.isDebugEnabled()) {
            _log.debug("\"Depth\" header is " + value);
        }
        if (value.equals("0")) {
            return 0L;
        }
        return -1L;
    }

    public static String getDestination(HttpServletRequest request, String rootPath) {
        String headerDestination = request.getHeader("Destination");
        String[] pathSegments = StringUtil.split(headerDestination, rootPath);
        String destination = pathSegments[pathSegments.length - 1];
        destination = HttpUtil.decodePath(destination);
        if (_log.isDebugEnabled()) {
            _log.debug("Destination " + destination);
        }
        return destination;
    }

    public static long getGroupId(long companyId, String path) throws WebDAVException {
        String[] pathArray = WebDAVUtil.getPathArray(path);
        return WebDAVUtil.getGroupId(companyId, pathArray);
    }

    public static long getGroupId(long companyId, String[] pathArray) throws WebDAVException {
        block5: {
            try {
                if (pathArray.length != 0) break block5;
                return 0L;
            }
            catch (Exception e) {
                throw new WebDAVException(e);
            }
        }
        String name = pathArray[0];
        Group group = GroupLocalServiceUtil.fetchFriendlyURLGroup(companyId, "/" + name);
        if (group != null) {
            return group.getGroupId();
        }
        User user = UserLocalServiceUtil.fetchUserByScreenName(companyId, name);
        if (user != null) {
            group = user.getGroup();
            return group.getGroupId();
        }
        return 0L;
    }

    public static List<Group> getGroups(long userId) throws Exception {
        User user = UserLocalServiceUtil.getUser(userId);
        return WebDAVUtil.getGroups(user);
    }

    public static List<Group> getGroups(User user) throws Exception {
        if (user.isDefaultUser()) {
            ArrayList<Group> groups = new ArrayList<Group>();
            Group group = GroupLocalServiceUtil.getGroup(user.getCompanyId(), "Guest");
            groups.add(group);
            return groups;
        }
        UniqueList<Group> groups = new UniqueList<Group>();
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("usersGroups", user.getUserId());
        GroupFriendlyURLComparator orderByComparator = new GroupFriendlyURLComparator(true);
        groups.addAll(GroupLocalServiceUtil.search(user.getCompanyId(), null, null, params, -1, -1, (OrderByComparator)orderByComparator));
        groups.addAll(GroupLocalServiceUtil.getUserOrganizationsGroups(user.getUserId(), -1, -1));
        if (!user.isDefaultUser()) {
            groups.add(user.getGroup());
        }
        Collections.sort(groups, orderByComparator);
        return groups;
    }

    public static WebDAVUtil getInstance() {
        PortalRuntimePermission.checkGetBeanProperty(WebDAVUtil.class);
        return _instance;
    }

    public static String getLockUuid(HttpServletRequest request) throws WebDAVException {
        String token = "";
        String value = GetterUtil.getString(request.getHeader("If"));
        if (_log.isDebugEnabled()) {
            _log.debug("\"If\" header is " + value);
        }
        if (value.contains("(<DAV:no-lock>)")) {
            if (_log.isWarnEnabled()) {
                _log.warn("Lock tokens can never be <DAV:no-lock>");
            }
            throw new WebDAVException();
        }
        int beg = value.indexOf(TOKEN_PREFIX);
        if (beg >= 0 && (beg += TOKEN_PREFIX.length()) < value.length()) {
            int end = value.indexOf(62, beg);
            token = GetterUtil.getString(value.substring(beg, end));
        }
        return token;
    }

    public static String[] getPathArray(String path) {
        return WebDAVUtil.getPathArray(path, false);
    }

    public static String[] getPathArray(String path, boolean fixTrailing) {
        path = HttpUtil.fixPath(path, true, fixTrailing);
        return StringUtil.split(path, '/');
    }

    public static String getResourceName(String[] pathArray) {
        if (pathArray.length <= 2) {
            return "";
        }
        return pathArray[pathArray.length - 1];
    }

    public static WebDAVStorage getStorage(String token) {
        return WebDAVUtil.getInstance()._getStorage(token);
    }

    public static Collection<String> getStorageTokens() {
        return WebDAVUtil.getInstance()._getStorageTokens();
    }

    public static long getTimeout(HttpServletRequest request) {
        int index;
        long timeout = 0L;
        String value = GetterUtil.getString(request.getHeader("Timeout"));
        if (_log.isDebugEnabled()) {
            _log.debug("\"Timeout\" header is " + value);
        }
        if ((index = value.indexOf("Second-")) >= 0 && (index += "Second-".length()) < value.length()) {
            timeout = GetterUtil.getLong(value.substring(index));
        }
        return timeout * 1000L;
    }

    public static boolean isOverwrite(HttpServletRequest request) {
        return WebDAVUtil.getInstance()._isOverwrite(request);
    }

    public static String stripManualCheckInRequiredPath(String url) {
        return WebDAVUtil.stripToken(url, "/manualCheckInRequired");
    }

    public static String stripOfficeExtension(String url) {
        String strippedUrl = WebDAVUtil.stripToken(url, "/officeExtension");
        if (strippedUrl.length() != url.length()) {
            strippedUrl = FileUtil.stripExtension(strippedUrl);
        }
        return strippedUrl;
    }

    public static String stripToken(String url, String token) {
        if (Validator.isNull(url)) {
            return "";
        }
        int index = url.indexOf(token);
        if (index >= 0) {
            url = String.valueOf(url.substring(0, index)) + url.substring(index + token.length());
        }
        return url;
    }

    private WebDAVUtil() {
    }

    private void _addStorage(WebDAVStorage storage) {
        this._storageMap.put(storage.getToken(), storage);
    }

    private void _deleteStorage(WebDAVStorage storage) {
        if (storage != null) {
            this._storageMap.remove(storage.getToken());
        }
    }

    private WebDAVStorage _getStorage(String token) {
        return this._storageMap.get(token);
    }

    private Collection<String> _getStorageTokens() {
        return this._storageMap.keySet();
    }

    private boolean _isOverwrite(HttpServletRequest request) {
        String value = GetterUtil.getString(request.getHeader("Overwrite"));
        return !StringUtil.equalsIgnoreCase(value, "F") && GetterUtil.getBoolean(value);
    }
}

