/*
 * Decompiled with CFR 0.152.
 */
package com.ecyrd.jspwiki.providers;

import com.ecyrd.jspwiki.NoRequiredPropertyException;
import com.ecyrd.jspwiki.QueryItem;
import com.ecyrd.jspwiki.TextUtil;
import com.ecyrd.jspwiki.WikiContext;
import com.ecyrd.jspwiki.WikiEngine;
import com.ecyrd.jspwiki.WikiPage;
import com.ecyrd.jspwiki.parser.MarkupParser;
import com.ecyrd.jspwiki.providers.ProviderException;
import com.ecyrd.jspwiki.providers.RepositoryModifiedException;
import com.ecyrd.jspwiki.providers.VersioningProvider;
import com.ecyrd.jspwiki.providers.WikiPageProvider;
import com.ecyrd.jspwiki.render.RenderingManager;
import com.ecyrd.jspwiki.util.ClassUtil;
import com.opensymphony.oscache.base.Cache;
import com.opensymphony.oscache.base.NeedsRefreshException;
import com.opensymphony.oscache.base.events.CacheEntryEvent;
import com.opensymphony.oscache.base.events.CacheEntryEventListener;
import com.opensymphony.oscache.base.events.CacheEventListener;
import com.opensymphony.oscache.base.events.CacheGroupEvent;
import com.opensymphony.oscache.base.events.CachePatternEvent;
import com.opensymphony.oscache.base.events.CachewideEvent;
import java.io.IOException;
import java.util.Collection;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import org.apache.log4j.Logger;

public class CachingProvider
implements WikiPageProvider,
VersioningProvider {
    private static final Logger log = Logger.getLogger(CachingProvider.class);
    private WikiPageProvider m_provider;
    private WikiEngine m_engine;
    private Cache m_cache;
    private Cache m_negCache;
    private Cache m_textCache;
    private Cache m_historyCache;
    private long m_cacheMisses = 0L;
    private long m_cacheHits = 0L;
    private long m_historyCacheMisses = 0L;
    private long m_historyCacheHits = 0L;
    private int m_expiryPeriod = 30;
    private int m_pageContentExpiryPeriod = 86400;
    private boolean m_gotall = false;
    private CacheItemCollector m_allCollector = new CacheItemCollector();
    public static final String PROP_CACHECHECKINTERVAL = "jspwiki.cachingProvider.cacheCheckInterval";
    public static final String PROP_CACHECAPACITY = "jspwiki.cachingProvider.capacity";
    private static final int DEFAULT_CACHECAPACITY = 1000;
    private static final String OSCACHE_ALGORITHM = "com.opensymphony.oscache.base.algorithm.LRUCache";

    public void initialize(WikiEngine engine, Properties properties) throws NoRequiredPropertyException, IOException {
        log.debug((Object)"Initing CachingProvider");
        this.m_engine = engine;
        this.m_expiryPeriod = TextUtil.getIntegerProperty(properties, PROP_CACHECHECKINTERVAL, this.m_expiryPeriod);
        log.debug((Object)("Cache expiry period is " + this.m_expiryPeriod + " s"));
        int capacity = TextUtil.getIntegerProperty(properties, PROP_CACHECAPACITY, 1000);
        log.debug((Object)("Cache capacity " + capacity + " pages."));
        this.m_cache = new Cache(true, false, false);
        this.m_cache.addCacheEventListener((CacheEventListener)this.m_allCollector, CacheEntryEventListener.class);
        this.m_negCache = new Cache(true, false, false);
        this.m_textCache = new Cache(true, false, false, false, OSCACHE_ALGORITHM, capacity);
        this.m_historyCache = new Cache(true, false, false, false, OSCACHE_ALGORITHM, capacity);
        String classname = WikiEngine.getRequiredProperty(properties, "jspwiki.pageProvider");
        try {
            Class providerclass = ClassUtil.findClass("com.ecyrd.jspwiki.providers", classname);
            this.m_provider = (WikiPageProvider)providerclass.newInstance();
            log.debug((Object)("Initializing real provider class " + this.m_provider));
            this.m_provider.initialize(engine, properties);
        }
        catch (ClassNotFoundException e) {
            log.error((Object)("Unable to locate provider class " + classname), (Throwable)e);
            throw new IllegalArgumentException("no provider class");
        }
        catch (InstantiationException e) {
            log.error((Object)("Unable to create provider class " + classname), (Throwable)e);
            throw new IllegalArgumentException("faulty provider class");
        }
        catch (IllegalAccessException e) {
            log.error((Object)("Illegal access to provider class " + classname), (Throwable)e);
            throw new IllegalArgumentException("illegal provider class");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WikiPage getPageInfoFromCache(String name) throws ProviderException, RepositoryModifiedException {
        boolean wasUpdated = false;
        if (name == null) {
            return null;
        }
        try {
            WikiPage item = (WikiPage)this.m_cache.getFromCache(name, this.m_expiryPeriod);
            wasUpdated = true;
            if (item != null) {
                WikiPage wikiPage = item;
                return wikiPage;
            }
            WikiPage wikiPage = null;
            return wikiPage;
        }
        catch (NeedsRefreshException e) {
            WikiPage cached = (WikiPage)e.getCacheContent();
            WikiPage refreshed = this.m_provider.getPageInfo(name, -1);
            if (refreshed == null && cached != null) {
                log.debug((Object)("Page " + name + " has been removed externally."));
                this.m_cache.putInCache(name, null);
                this.m_textCache.putInCache(name, null);
                this.m_historyCache.putInCache(name, null);
                this.m_negCache.putInCache(name, (Object)name);
                wasUpdated = true;
                throw new RepositoryModifiedException("Removed: " + name, name);
            }
            if (cached == null) {
                if (refreshed != null) {
                    this.m_cache.putInCache(name, (Object)refreshed);
                    this.m_negCache.putInCache(name, null);
                    wasUpdated = true;
                    throw new RepositoryModifiedException("Added: " + name, name);
                }
                this.m_negCache.putInCache(name, (Object)name);
            } else {
                if (refreshed != null && cached.getVersion() != refreshed.getVersion()) {
                    log.debug((Object)("Page " + cached.getName() + " newest version deleted, reloading..."));
                    this.m_cache.putInCache(name, (Object)refreshed);
                    this.m_negCache.removeEntry(name);
                    this.m_textCache.removeEntry(name);
                    this.m_historyCache.removeEntry(name);
                    wasUpdated = true;
                    WikiPage wikiPage = refreshed;
                    return wikiPage;
                }
                if (refreshed != null && Math.abs(refreshed.getLastModified().getTime() - cached.getLastModified().getTime()) > 1000L) {
                    log.info((Object)("Page " + cached.getName() + " changed, reloading..."));
                    this.m_cache.putInCache(name, (Object)refreshed);
                    this.m_negCache.removeEntry(name);
                    this.m_textCache.removeEntry(name);
                    this.m_historyCache.removeEntry(name);
                    wasUpdated = true;
                    throw new RepositoryModifiedException("Modified: " + name, name);
                }
                this.m_cache.putInCache(name, (Object)cached);
                this.m_negCache.putInCache(name, null);
                wasUpdated = true;
            }
            WikiPage wikiPage = cached;
            return wikiPage;
        }
        finally {
            if (!wasUpdated) {
                this.m_cache.cancelUpdate(name);
            }
        }
    }

    public boolean pageExists(String pageName, int version) {
        if (pageName == null) {
            return false;
        }
        try {
            String isNonExistant = (String)this.m_negCache.getFromCache(pageName, this.m_expiryPeriod);
            if (isNonExistant != null) {
                return false;
            }
        }
        catch (NeedsRefreshException e) {
            this.m_negCache.cancelUpdate(pageName);
        }
        WikiPage p = null;
        try {
            p = this.getPageInfoFromCache(pageName);
        }
        catch (RepositoryModifiedException e) {
            try {
                p = this.getPageInfoFromCache(pageName);
            }
            catch (Exception ex) {
                return false;
            }
        }
        catch (ProviderException e) {
            log.info((Object)("Provider failed while trying to check if page exists: " + pageName));
            return false;
        }
        if (p != null) {
            int latestVersion = p.getVersion();
            if (version == latestVersion || version == -1) {
                return true;
            }
            if (this.m_provider instanceof VersioningProvider) {
                return ((VersioningProvider)((Object)this.m_provider)).pageExists(pageName, version);
            }
        }
        try {
            return this.getPageInfo(pageName, version) != null;
        }
        catch (ProviderException e) {
            return false;
        }
    }

    public boolean pageExists(String pageName) {
        if (pageName == null) {
            return false;
        }
        try {
            String isNonExistant = (String)this.m_negCache.getFromCache(pageName, this.m_expiryPeriod);
            if (isNonExistant != null) {
                return false;
            }
        }
        catch (NeedsRefreshException e) {
            this.m_negCache.cancelUpdate(pageName);
        }
        WikiPage p = null;
        try {
            p = this.getPageInfoFromCache(pageName);
        }
        catch (RepositoryModifiedException e) {
            try {
                p = this.getPageInfoFromCache(pageName);
            }
            catch (Exception ex) {
                return false;
            }
        }
        catch (ProviderException e) {
            log.info((Object)("Provider failed while trying to check if page exists: " + pageName));
            return false;
        }
        if (p != null) {
            return true;
        }
        if (this.m_gotall) {
            return false;
        }
        return this.m_provider.pageExists(pageName);
    }

    public String getPageText(String pageName, int version) throws ProviderException, RepositoryModifiedException {
        WikiPage p;
        String result = null;
        if (pageName == null) {
            return null;
        }
        result = version == -1 ? this.getTextFromCache(pageName) : ((p = this.getPageInfoFromCache(pageName)) != null && p.getVersion() == version ? this.getTextFromCache(pageName) : this.m_provider.getPageText(pageName, version));
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getTextFromCache(String pageName) throws ProviderException, RepositoryModifiedException {
        String text;
        boolean wasUpdated = false;
        if (pageName == null) {
            return null;
        }
        WikiPage page = this.getPageInfoFromCache(pageName);
        try {
            text = (String)this.m_textCache.getFromCache(pageName, this.m_pageContentExpiryPeriod);
            wasUpdated = true;
            if (text == null) {
                if (page != null) {
                    text = this.m_provider.getPageText(pageName, -1);
                    this.m_textCache.putInCache(pageName, (Object)text);
                    ++this.m_cacheMisses;
                    return text;
                }
                String string = null;
                return string;
            }
            ++this.m_cacheHits;
            return text;
        }
        catch (NeedsRefreshException e) {
            if (this.pageExists(pageName)) {
                text = this.m_provider.getPageText(pageName, -1);
                this.m_textCache.putInCache(pageName, (Object)text);
                wasUpdated = true;
                ++this.m_cacheMisses;
                return text;
            }
            this.m_textCache.putInCache(pageName, null);
            wasUpdated = true;
            String string = null;
            return string;
        }
        finally {
            if (!wasUpdated) {
                this.m_textCache.cancelUpdate(pageName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putPageText(WikiPage page, String text) throws ProviderException {
        CachingProvider cachingProvider = this;
        synchronized (cachingProvider) {
            this.m_provider.putPageText(page, text);
            page.setLastModified(new Date());
            this.m_cache.removeEntry(page.getName());
            this.m_textCache.removeEntry(page.getName());
            this.m_historyCache.removeEntry(page.getName());
            this.m_negCache.removeEntry(page.getName());
            try {
                this.getPageInfoFromCache(page.getName());
            }
            catch (RepositoryModifiedException e) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getAllPages() throws ProviderException {
        Collection all;
        if (!this.m_gotall) {
            all = this.m_provider.getAllPages();
            CachingProvider cachingProvider = this;
            synchronized (cachingProvider) {
                for (WikiPage p : all) {
                    this.m_cache.putInCache(p.getName(), (Object)p);
                    this.m_negCache.putInCache(p.getName(), null);
                }
                this.m_gotall = true;
            }
        } else {
            all = this.m_allCollector.getAllItems();
        }
        return all;
    }

    public Collection getAllChangedSince(Date date) {
        return this.m_provider.getAllChangedSince(date);
    }

    public int getPageCount() throws ProviderException {
        return this.m_provider.getPageCount();
    }

    public Collection findPages(QueryItem[] query) {
        return this.m_provider.findPages(query);
    }

    private void refreshMetadata(WikiPage page) {
        if (page != null && !page.hasMetadata()) {
            RenderingManager mgr = this.m_engine.getRenderingManager();
            try {
                String data = this.m_provider.getPageText(page.getName(), page.getVersion());
                WikiContext ctx = new WikiContext(this.m_engine, page);
                MarkupParser parser = mgr.getParser(ctx, data);
                parser.parse();
            }
            catch (Exception ex) {
                log.debug((Object)("Failed to retrieve variables for wikipage " + page));
            }
        }
    }

    public WikiPage getPageInfo(String pageName, int version) throws ProviderException, RepositoryModifiedException {
        int latestcached;
        WikiPage page = null;
        WikiPage cached = this.getPageInfoFromCache(pageName);
        int n = latestcached = cached != null ? cached.getVersion() : Integer.MIN_VALUE;
        if (version == -1 || version == latestcached) {
            if (cached == null) {
                WikiPage data = this.m_provider.getPageInfo(pageName, version);
                if (data != null) {
                    this.m_cache.putInCache(pageName, (Object)data);
                    this.m_negCache.putInCache(pageName, null);
                }
                page = data;
            } else {
                page = cached;
            }
        } else {
            page = this.m_provider.getPageInfo(pageName, version);
        }
        this.refreshMetadata(page);
        return page;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getVersionHistory(String pageName) throws ProviderException {
        List history = null;
        boolean wasUpdated = false;
        if (pageName == null) {
            return null;
        }
        try {
            history = (List)this.m_historyCache.getFromCache(pageName, this.m_expiryPeriod);
            log.debug((Object)("History cache hit for page " + pageName));
            ++this.m_historyCacheHits;
            wasUpdated = true;
        }
        catch (NeedsRefreshException e) {
            history = this.m_provider.getVersionHistory(pageName);
            this.m_historyCache.putInCache(pageName, (Object)history);
            log.debug((Object)("History cache miss for page " + pageName));
            ++this.m_historyCacheMisses;
            wasUpdated = true;
        }
        finally {
            if (!wasUpdated) {
                this.m_historyCache.cancelUpdate(pageName);
            }
        }
        return history;
    }

    public synchronized String getProviderInfo() {
        return "Real provider: " + this.m_provider.getClass().getName() + ". Cache misses: " + this.m_cacheMisses + ". Cache hits: " + this.m_cacheHits + ". History cache hits: " + this.m_historyCacheHits + ". History cache misses: " + this.m_historyCacheMisses + ". Cache consistency checks: " + this.m_expiryPeriod + "s";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteVersion(String pageName, int version) throws ProviderException {
        CachingProvider cachingProvider = this;
        synchronized (cachingProvider) {
            int latestcached;
            WikiPage cached = this.getPageInfoFromCache(pageName);
            int n = latestcached = cached != null ? cached.getVersion() : Integer.MIN_VALUE;
            if (version == -1 || version == latestcached) {
                this.m_cache.removeEntry(pageName);
                this.m_textCache.removeEntry(pageName);
            }
            this.m_provider.deleteVersion(pageName, version);
            this.m_historyCache.removeEntry(pageName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deletePage(String pageName) throws ProviderException {
        CachingProvider cachingProvider = this;
        synchronized (cachingProvider) {
            this.m_cache.putInCache(pageName, null);
            this.m_textCache.putInCache(pageName, null);
            this.m_historyCache.putInCache(pageName, null);
            this.m_negCache.putInCache(pageName, (Object)pageName);
            this.m_provider.deletePage(pageName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void movePage(String from, String to) throws ProviderException {
        this.m_provider.movePage(from, to);
        CachingProvider cachingProvider = this;
        synchronized (cachingProvider) {
            log.debug((Object)("Removing from page " + from + " from cache"));
            this.m_cache.putInCache(from, null);
            this.m_textCache.putInCache(from, null);
            this.m_historyCache.putInCache(from, null);
            this.m_negCache.putInCache(from, (Object)from);
            log.debug((Object)("Removing to page " + to + " from cache"));
            this.m_cache.putInCache(to, null);
            this.m_textCache.putInCache(to, null);
            this.m_historyCache.putInCache(to, null);
            this.m_negCache.putInCache(to, (Object)to);
        }
    }

    public WikiPageProvider getRealProvider() {
        return this.m_provider;
    }

    private static class CacheItemCollector
    implements CacheEntryEventListener {
        private Map<String, WikiPage> m_allItems = new Hashtable<String, WikiPage>();

        private CacheItemCollector() {
        }

        public Set getAllItems() {
            TreeSet<WikiPage> ret = new TreeSet<WikiPage>();
            ret.addAll(this.m_allItems.values());
            return ret;
        }

        public void cacheEntryAdded(CacheEntryEvent arg0) {
            this.cacheEntryUpdated(arg0);
        }

        public void cachePatternFlushed(CachePatternEvent ev) {
        }

        public void cacheGroupFlushed(CacheGroupEvent ev) {
        }

        public void cacheFlushed(CachewideEvent ev) {
        }

        public void cacheEntryFlushed(CacheEntryEvent arg0) {
            this.cacheEntryRemoved(arg0);
        }

        public void cacheEntryRemoved(CacheEntryEvent arg0) {
            WikiPage item;
            if (arg0.getEntry() != null && (item = (WikiPage)arg0.getEntry().getContent()) != null) {
                this.m_allItems.remove(item.getName());
            }
        }

        public void cacheEntryUpdated(CacheEntryEvent arg0) {
            WikiPage item = (WikiPage)arg0.getEntry().getContent();
            if (item != null) {
                this.m_allItems.put(item.getName(), item);
            } else {
                this.m_allItems.remove(arg0.getKey());
            }
        }
    }
}

