/*
 * Decompiled with CFR 0.152.
 */
package com.ecyrd.jspwiki.tags;

import com.ecyrd.jspwiki.InternalWikiException;
import com.ecyrd.jspwiki.WikiEngine;
import com.ecyrd.jspwiki.WikiPage;
import com.ecyrd.jspwiki.providers.ProviderException;
import com.ecyrd.jspwiki.tags.WikiTagBase;
import java.io.IOException;

public class CheckVersionTag
extends WikiTagBase {
    private static final long serialVersionUID = 0L;
    private VersionMode m_mode;

    public void initTag() {
        super.initTag();
        this.m_mode = VersionMode.LATEST;
    }

    public void setMode(String arg) {
        this.m_mode = "latest".equals(arg) ? VersionMode.LATEST : ("notfirst".equals(arg) ? VersionMode.NOTFIRST : ("first".equals(arg) ? VersionMode.FIRST : VersionMode.NOTLATEST));
    }

    public final int doWikiStartTag() throws IOException, ProviderException {
        WikiEngine engine = this.m_wikiContext.getEngine();
        WikiPage page = this.m_wikiContext.getPage();
        if (page != null && engine.pageExists(page.getName())) {
            int version = page.getVersion();
            boolean include = false;
            WikiPage latest = engine.getPage(page.getName());
            switch (this.m_mode) {
                case LATEST: {
                    include = version < 0 || latest.getVersion() == version;
                    break;
                }
                case NOTLATEST: {
                    include = version > 0 && latest.getVersion() != version;
                    break;
                }
                case FIRST: {
                    include = version == 1 || version < 0 && latest.getVersion() == 1;
                    break;
                }
                case NOTFIRST: {
                    include = version > 1;
                    break;
                }
                default: {
                    throw new InternalWikiException("Mode which is not available!");
                }
            }
            if (include) {
                return 1;
            }
        }
        return 0;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum VersionMode {
        LATEST,
        NOTLATEST,
        FIRST,
        NOTFIRST;

    }
}

