/*
 * Decompiled with CFR 0.152.
 */
package com.ecyrd.jspwiki.ui;

import com.ecyrd.jspwiki.InternalWikiException;
import com.ecyrd.jspwiki.WikiContext;
import com.ecyrd.jspwiki.WikiEngine;
import com.ecyrd.jspwiki.modules.ModuleManager;
import com.ecyrd.jspwiki.preferences.Preferences;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeSet;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.zip.ZipInputStream;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.jstl.fmt.LocaleSupport;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class TemplateManager
extends ModuleManager {
    private static final String SKIN_DIRECTORY = "skins";
    public static final String RESOURCE_JSFUNCTION = "jsfunction";
    public static final String RESOURCE_JSLOCALIZEDSTRINGS = "jslocalizedstrings";
    public static final String RESOURCE_STYLESHEET = "stylesheet";
    public static final String RESOURCE_SCRIPT = "script";
    public static final String RESOURCE_INLINECSS = "inlinecss";
    public static final String DIRECTORY = "templates";
    public static final String DEFAULT_TEMPLATE = "default";
    public static final String PROPERTYFILE = "template.properties";
    public static final String I18NRESOURCE_PATH = "/WEB-INF/lib/JSPWiki.jar";
    public static final String I18NRESOURCE_PREFIX = "templates/default_";
    public static final String I18NRESOURCE_SUFFIX = ".properties";
    public static final String I18NDEFAULT_LOCALE = "prefs.user.language.default";
    public static final String I18NSERVER_TIMEZONE = "prefs.user.timezone.server";
    public static final String TIMEFORMATPROPERTIES = "jspwiki.defaultprefs.timeformat.";
    public static final String RESOURCE_INCLUDES = "jspwiki.resourceincludes";
    protected static final Logger log = Logger.getLogger(TemplateManager.class);
    public static final String RESOURCE_HTTPHEADER = "httpheader";

    public TemplateManager(WikiEngine engine, Properties properties) {
        super(engine);
    }

    public boolean templateExists(String templateName) {
        ServletContext context = this.m_engine.getServletContext();
        InputStream in = context.getResourceAsStream(TemplateManager.getPath(templateName) + "ViewTemplate.jsp");
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            return true;
        }
        return false;
    }

    private static String findResource(ServletContext sContext, String name) {
        InputStream is = sContext.getResourceAsStream(name);
        if (is == null) {
            String defname = TemplateManager.makeFullJSPName(DEFAULT_TEMPLATE, TemplateManager.removeTemplatePart(name));
            is = sContext.getResourceAsStream(defname);
            name = is != null ? defname : null;
        }
        if (is != null) {
            try {
                is.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return name;
    }

    private static String findResource(ServletContext sContext, String template, String name) {
        if (name.charAt(0) == '/') {
            return TemplateManager.findResource(sContext, name);
        }
        String fullname = TemplateManager.makeFullJSPName(template, name);
        return TemplateManager.findResource(sContext, fullname);
    }

    public String findJSP(PageContext pageContext, String name) {
        ServletContext sContext = pageContext.getServletContext();
        return TemplateManager.findResource(sContext, name);
    }

    private static final String removeTemplatePart(String name) {
        int idx = 0;
        if (name.startsWith("/")) {
            idx = 1;
        }
        if ((idx = name.indexOf(47, idx)) != -1 && (idx = name.indexOf(47, idx + 1)) != -1) {
            name = name.substring(idx + 1);
        }
        log.info((Object)("Final name = " + name));
        return name;
    }

    private static final String makeFullJSPName(String template, String name) {
        return "/templates/" + template + "/" + name;
    }

    public String findJSP(PageContext pageContext, String template, String name) {
        if (name == null || template == null) {
            log.fatal((Object)("findJSP() was asked to find a null template or name (" + template + "," + name + ")." + " JSP page '" + ((HttpServletRequest)pageContext.getRequest()).getRequestURI() + "'"));
            throw new InternalWikiException("Illegal arguments to findJSP(); please check logs.");
        }
        return TemplateManager.findResource(pageContext.getServletContext(), template, name);
    }

    public String findResource(WikiContext ctx, String template, String name) {
        if (this.m_engine.getServletContext() != null) {
            return TemplateManager.findResource(this.m_engine.getServletContext(), template, name);
        }
        return TemplateManager.getPath(template) + "/" + name;
    }

    private static final String getPath(String template) {
        return "/templates/" + template + "/";
    }

    public Set listSkins(PageContext pageContext, String template) {
        String place = TemplateManager.makeFullJSPName(template, SKIN_DIRECTORY);
        ServletContext sContext = pageContext.getServletContext();
        Set skinSet = sContext.getResourcePaths(place);
        TreeSet<String> resultSet = new TreeSet<String>();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Listings skins from " + place));
        }
        if (skinSet != null) {
            String[] skins = new String[]{};
            skins = skinSet.toArray(skins);
            for (int i = 0; i < skins.length; ++i) {
                String[] s = StringUtils.split((String)skins[i], (String)"/");
                if (s.length <= 2 || !skins[i].endsWith("/")) continue;
                String skinName = s[s.length - 1];
                resultSet.add(skinName);
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("...adding skin '" + skinName + "'"));
            }
        }
        return resultSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map listLanguages(PageContext pageContext) {
        LinkedHashMap<String, String> resultMap = new LinkedHashMap<String, String>();
        String clientLanguage = ((HttpServletRequest)pageContext.getRequest()).getLocale().toString();
        ZipInputStream jarStream = null;
        try {
            JarEntry entry;
            InputStream inputStream = pageContext.getServletContext().getResourceAsStream(I18NRESOURCE_PATH);
            jarStream = new JarInputStream(inputStream);
            while ((entry = ((JarInputStream)jarStream).getNextJarEntry()) != null) {
                String name = entry.getName();
                if (entry.isDirectory() || !name.startsWith(I18NRESOURCE_PREFIX) || !name.endsWith(I18NRESOURCE_SUFFIX)) continue;
                name = name.substring(I18NRESOURCE_PREFIX.length(), name.lastIndexOf(I18NRESOURCE_SUFFIX));
                Locale locale = new Locale(name.substring(0, 2), name.indexOf("_") == -1 ? "" : name.substring(3, 5));
                String defaultLanguage = "";
                if (clientLanguage.startsWith(name)) {
                    defaultLanguage = LocaleSupport.getLocalizedMessage((PageContext)pageContext, (String)I18NDEFAULT_LOCALE);
                }
                resultMap.put(name, locale.getDisplayName(locale) + " " + defaultLanguage);
            }
        }
        catch (IOException ioe) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Could not search jar file '/WEB-INF/lib/JSPWiki.jar'for properties files due to an IOException: \n" + ioe.getMessage()));
            }
        }
        finally {
            if (jarStream != null) {
                try {
                    jarStream.close();
                }
                catch (IOException e) {}
            }
        }
        return resultMap;
    }

    public Map listTimeFormats(PageContext pageContext) {
        WikiContext context = WikiContext.findContext(pageContext);
        Properties props = this.m_engine.getWikiProperties();
        ArrayList<String> tfArr = new ArrayList<String>(40);
        LinkedHashMap<String, String> resultMap = new LinkedHashMap<String, String>();
        Enumeration<?> e = props.propertyNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            if (!name.startsWith(TIMEFORMATPROPERTIES)) continue;
            tfArr.add(name);
        }
        if (tfArr.size() == 0) {
            tfArr.add("dd-MMM-yy");
            tfArr.add("d-MMM-yyyy");
            tfArr.add("EEE, dd-MMM-yyyy, zzzz");
        } else {
            Collections.sort(tfArr);
            for (int i = 0; i < tfArr.size(); ++i) {
                tfArr.set(i, props.getProperty((String)tfArr.get(i)));
            }
        }
        String prefTimeZone = Preferences.getPreference(context, "TimeZone");
        TimeZone tz = TimeZone.getTimeZone(prefTimeZone);
        Date d = new Date();
        try {
            SimpleDateFormat fmt = Preferences.getDateFormat(context, Preferences.TimeFormat.DATETIME);
            fmt.setTimeZone(tz);
            for (int i = 0; i < tfArr.size(); ++i) {
                try {
                    String f = (String)tfArr.get(i);
                    fmt.applyPattern(f);
                    resultMap.put(f, fmt.format(d));
                    continue;
                }
                catch (IllegalArgumentException e2) {
                    // empty catch block
                }
            }
        }
        catch (IllegalArgumentException e3) {
            // empty catch block
        }
        return resultMap;
    }

    public Map listTimeZones(PageContext pageContext) {
        LinkedHashMap<String, String> resultMap = new LinkedHashMap<String, String>();
        String[][] tzs = new String[][]{{"GMT-12", "Enitwetok, Kwajalien"}, {"GMT-11", "Nome, Midway Island, Samoa"}, {"GMT-10", "Hawaii"}, {"GMT-9", "Alaska"}, {"GMT-8", "Pacific Time"}, {"GMT-7", "Mountain Time"}, {"GMT-6", "Central Time, Mexico City"}, {"GMT-5", "Eastern Time, Bogota, Lima, Quito"}, {"GMT-4", "Atlantic Time, Caracas, La Paz"}, {"GMT-3:30", "Newfoundland"}, {"GMT-3", "Brazil, Buenos Aires, Georgetown, Falkland Is."}, {"GMT-2", "Mid-Atlantic, Ascention Is., St Helena"}, {"GMT-1", "Azores, Cape Verde Islands"}, {"GMT", "Casablanca, Dublin, Edinburgh, London, Lisbon, Monrovia"}, {"GMT+1", "Berlin, Brussels, Copenhagen, Madrid, Paris, Rome"}, {"GMT+2", "Helsinki, Athens, Kaliningrad, South Africa, Warsaw"}, {"GMT+3", "Baghdad, Riyadh, Moscow, Nairobi"}, {"GMT+3:30", "Tehran"}, {"GMT+4", "Adu Dhabi, Baku, Muscat, Tbilisi"}, {"GMT+4:30", "Kabul"}, {"GMT+5", "Islamabad, Karachi, Tashkent"}, {"GMT+5:30", "Bombay, Calcutta, Madras, New Delhi"}, {"GMT+6", "Almaty, Colomba, Dhakra"}, {"GMT+7", "Bangkok, Hanoi, Jakarta"}, {"GMT+8", "Beijing, Hong Kong, Perth, Singapore, Taipei"}, {"GMT+9", "Osaka, Sapporo, Seoul, Tokyo, Yakutsk"}, {"GMT+9:30", "Adelaide, Darwin"}, {"GMT+10", "Melbourne, Papua New Guinea, Sydney, Vladivostok"}, {"GMT+11", "Magadan, New Caledonia, Solomon Islands"}, {"GMT+12", "Auckland, Wellington, Fiji, Marshall Island"}};
        TimeZone servertz = TimeZone.getDefault();
        for (int i = 0; i < tzs.length; ++i) {
            String tzID = tzs[i][0];
            TimeZone tz = TimeZone.getTimeZone(tzID);
            String serverTimeZone = "";
            if (servertz.getRawOffset() == tz.getRawOffset()) {
                serverTimeZone = LocaleSupport.getLocalizedMessage((PageContext)pageContext, (String)I18NSERVER_TIMEZONE);
                tzID = servertz.getID();
            }
            resultMap.put(tzID, "(" + tzs[i][0] + ") " + tzs[i][1] + " " + serverTimeZone);
        }
        return resultMap;
    }

    public static String getMarker(WikiContext context, String type) {
        if (type.equals(RESOURCE_JSLOCALIZEDSTRINGS)) {
            return TemplateManager.getJSLocalizedStrings(context);
        }
        if (type.equals(RESOURCE_JSFUNCTION)) {
            return "/* INCLUDERESOURCES (" + type + ") */";
        }
        return "<!-- INCLUDERESOURCES (" + type + ") -->";
    }

    private static String getJSLocalizedStrings(WikiContext context) {
        StringBuffer sb = new StringBuffer();
        sb.append("var LocalizedStrings = {\n");
        ResourceBundle rb = context.getBundle("templates.default");
        boolean first = true;
        Enumeration<String> en = rb.getKeys();
        while (en.hasMoreElements()) {
            String key = en.nextElement();
            if (!key.startsWith("javascript")) continue;
            if (first) {
                first = false;
            } else {
                sb.append(",\n");
            }
            sb.append("\"" + key + "\":\"" + rb.getString(key) + "\"");
        }
        sb.append("\n};\n");
        return sb.toString();
    }

    public static void addResourceRequest(WikiContext ctx, String type, String resource) {
        Vector<String> resources;
        HashMap resourcemap = (HashMap)ctx.getVariable(RESOURCE_INCLUDES);
        if (resourcemap == null) {
            resourcemap = new HashMap();
        }
        if ((resources = (Vector<String>)resourcemap.get(type)) == null) {
            resources = new Vector<String>();
        }
        String resourceString = null;
        if (type.equals(RESOURCE_SCRIPT)) {
            resourceString = "<script type='text/javascript' src='" + resource + "'></script>";
        } else if (type.equals(RESOURCE_STYLESHEET)) {
            resourceString = "<link rel='stylesheet' type='text/css' href='" + resource + "' />";
        } else if (type.equals(RESOURCE_INLINECSS)) {
            resourceString = "<style type='text/css'>\n" + resource + "\n</style>\n";
        } else if (type.equals(RESOURCE_JSFUNCTION)) {
            resourceString = resource;
        } else if (type.equals(RESOURCE_HTTPHEADER)) {
            resourceString = resource;
        }
        if (resourceString != null) {
            resources.add(resourceString);
        }
        log.debug((Object)("Request to add a resource: " + resourceString));
        resourcemap.put(type, resources);
        ctx.setVariable(RESOURCE_INCLUDES, resourcemap);
    }

    public static String[] getResourceRequests(WikiContext ctx, String type) {
        HashMap hm = (HashMap)ctx.getVariable(RESOURCE_INCLUDES);
        if (hm == null) {
            return new String[0];
        }
        Vector resources = (Vector)hm.get(type);
        if (resources == null) {
            return new String[0];
        }
        String[] res = new String[resources.size()];
        return resources.toArray(res);
    }

    public static String[] getResourceTypes(WikiContext ctx) {
        HashMap hm;
        String[] res = new String[]{};
        if (ctx != null && (hm = (HashMap)ctx.getVariable(RESOURCE_INCLUDES)) != null) {
            Set keys = hm.keySet();
            res = keys.toArray(res);
        }
        return res;
    }

    public Collection modules() {
        return new ArrayList();
    }
}

