/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.bobo.analysis.section;

import java.io.IOException;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.PayloadAttribute;
import org.apache.lucene.index.Payload;

public final class SectionTokenStream
extends TokenFilter {
    private Payload _payload;
    private PayloadAttribute _payloadAtt = (PayloadAttribute)this.addAttribute(PayloadAttribute.class);

    public SectionTokenStream(TokenStream tokenStream, int sectionId) {
        super(tokenStream);
        this._payload = SectionTokenStream.encodeIntPayload(sectionId);
    }

    public boolean incrementToken() throws IOException {
        if (this.input.incrementToken()) {
            this._payloadAtt.setPayload(this._payload);
            return true;
        }
        return false;
    }

    public static Payload encodeIntPayload(int id) {
        byte[] data = new byte[4];
        int off = data.length;
        do {
            data[--off] = (byte)id;
        } while ((id >>>= 8) > 0);
        return new Payload(data, off, data.length - off);
    }

    public static int decodeIntPayload(Payload payload) {
        return SectionTokenStream.decodeIntPayload(payload.getData(), payload.getOffset(), payload.length());
    }

    public static int decodeIntPayload(byte[] data, int off, int len) {
        int endOff = off + len;
        int val = 0;
        while (off < endOff) {
            val <<= 8;
            val += data[off++] & 0xFF;
        }
        return val;
    }
}

