/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.bobo.docidset;

import java.io.IOException;
import org.apache.lucene.search.DocIdSetIterator;

public abstract class FilteredDocSetIterator
extends DocIdSetIterator {
    protected DocIdSetIterator _innerIter;
    private int _currentDoc;

    public FilteredDocSetIterator(DocIdSetIterator innerIter) {
        if (innerIter == null) {
            throw new IllegalArgumentException("null iterator");
        }
        this._innerIter = innerIter;
        this._currentDoc = -1;
    }

    protected abstract boolean match(int var1);

    public final int docID() {
        return this._currentDoc;
    }

    public final int nextDoc() throws IOException {
        int docid = this._innerIter.nextDoc();
        while (docid != Integer.MAX_VALUE) {
            if (this.match(docid)) {
                this._currentDoc = docid;
                return docid;
            }
            docid = this._innerIter.nextDoc();
        }
        return Integer.MAX_VALUE;
    }

    public final int advance(int n) throws IOException {
        int docid = this._innerIter.advance(n);
        while (docid != Integer.MAX_VALUE) {
            if (this.match(docid)) {
                this._currentDoc = docid;
                return docid;
            }
            docid = this._innerIter.nextDoc();
        }
        return Integer.MAX_VALUE;
    }
}

