/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.bobo.search.section;

import java.io.IOException;
import org.apache.lucene.util.PriorityQueue;

public abstract class SectionSearchQueryPlan {
    public static final int NO_MORE_POSITIONS = Integer.MAX_VALUE;
    public static final int NO_MORE_SECTIONS = Integer.MAX_VALUE;
    protected int _curDoc = -1;
    protected int _curSec = -1;

    public int getDocId() {
        return this._curDoc;
    }

    public int getSecId() {
        return this._curSec;
    }

    public int fetch(int targetDoc) throws IOException {
        while (this.fetchDoc(targetDoc) < Integer.MAX_VALUE) {
            if (this.fetchSec(0) >= Integer.MAX_VALUE) continue;
            return this._curDoc;
        }
        return this._curDoc;
    }

    public abstract int fetchDoc(int var1) throws IOException;

    public abstract int fetchSec(int var1) throws IOException;

    protected int fetchPos() throws IOException {
        return Integer.MAX_VALUE;
    }

    public static class NodeQueue
    extends PriorityQueue {
        public NodeQueue(int size) {
            this.initialize(size);
        }

        protected boolean lessThan(Object objA, Object objB) {
            SectionSearchQueryPlan nodeA = (SectionSearchQueryPlan)objA;
            SectionSearchQueryPlan nodeB = (SectionSearchQueryPlan)objB;
            if (nodeA._curDoc == nodeB._curDoc) {
                return nodeA._curSec < nodeB._curSec;
            }
            return nodeA._curDoc < nodeB._curDoc;
        }
    }
}

