/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.bobo.search.section;

import com.browseengine.bobo.search.section.AndNode;
import com.browseengine.bobo.search.section.AndNotNode;
import com.browseengine.bobo.search.section.MetaDataCache;
import com.browseengine.bobo.search.section.MetaDataCacheProvider;
import com.browseengine.bobo.search.section.MetaDataQuery;
import com.browseengine.bobo.search.section.OrNode;
import com.browseengine.bobo.search.section.PhraseNode;
import com.browseengine.bobo.search.section.SectionSearchQueryPlan;
import com.browseengine.bobo.search.section.TermNode;
import com.browseengine.bobo.search.section.UnaryNotNode;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;

public class SectionSearchQueryPlanBuilder {
    protected final IndexReader _reader;
    protected final MetaDataCacheProvider _cacheProvider;

    public SectionSearchQueryPlanBuilder(IndexReader reader) {
        this._reader = reader;
        this._cacheProvider = reader instanceof MetaDataCacheProvider ? (MetaDataCacheProvider)reader : null;
    }

    public SectionSearchQueryPlan getPlan(Query query) throws IOException {
        SectionSearchQueryPlan textSearchPlan;
        if (query != null && !((textSearchPlan = this.translate(query)) instanceof UnaryNotNode)) {
            return textSearchPlan;
        }
        return null;
    }

    private SectionSearchQueryPlan translate(Query query) throws IOException {
        if (query != null) {
            if (query instanceof TermQuery) {
                return this.translateTermQuery((TermQuery)query);
            }
            if (query instanceof PhraseQuery) {
                return this.translatePhraseQuery((PhraseQuery)query);
            }
            if (query instanceof BooleanQuery) {
                return this.translateBooleanQuery((BooleanQuery)query);
            }
            if (query instanceof MetaDataQuery) {
                MetaDataCache cache;
                MetaDataQuery mquery = (MetaDataQuery)query;
                MetaDataCache metaDataCache = cache = this._cacheProvider != null ? this._cacheProvider.get(mquery.getTerm()) : null;
                if (cache != null) {
                    return ((MetaDataQuery)query).getPlan(cache);
                }
                return ((MetaDataQuery)query).getPlan(this._reader);
            }
            throw new TranslationException("unable to translate Query class: " + query.getClass().getName());
        }
        return null;
    }

    private SectionSearchQueryPlan translateTermQuery(TermQuery query) throws IOException {
        return new TermNode(query.getTerm(), this._reader);
    }

    private SectionSearchQueryPlan translatePhraseQuery(PhraseQuery query) throws IOException {
        Term[] terms = query.getTerms();
        TermNode[] nodes = new TermNode[terms.length];
        int[] positions = query.getPositions();
        for (int i = 0; i < terms.length; ++i) {
            nodes[i] = new TermNode(terms[i], positions[i], this._reader);
        }
        return new PhraseNode(nodes, this._reader);
    }

    private SectionSearchQueryPlan translateBooleanQuery(BooleanQuery query) throws IOException {
        BooleanClause[] clauses;
        ArrayList<Query> requiredClauses = new ArrayList<Query>();
        ArrayList<Query> prohibitedClauses = new ArrayList<Query>();
        ArrayList<Query> optionalClauses = new ArrayList<Query>();
        for (BooleanClause clause : clauses = query.getClauses()) {
            if (clause.isRequired()) {
                requiredClauses.add(clause.getQuery());
                continue;
            }
            if (clause.isProhibited()) {
                prohibitedClauses.add(clause.getQuery());
                continue;
            }
            optionalClauses.add(clause.getQuery());
        }
        SectionSearchQueryPlan positiveNode = null;
        SectionSearchQueryPlan negativeNode = null;
        if (requiredClauses.size() > 0) {
            if (requiredClauses.size() == 1) {
                positiveNode = this.translate(requiredClauses.get(0));
            } else {
                SectionSearchQueryPlan[] subqueries = this.translate(requiredClauses);
                if (subqueries != null && subqueries.length > 0) {
                    positiveNode = new AndNode(subqueries);
                }
            }
        } else if (optionalClauses.size() > 0) {
            if (optionalClauses.size() == 1) {
                positiveNode = this.translate(optionalClauses.get(0));
            } else {
                SectionSearchQueryPlan[] subqueries = this.translate(optionalClauses);
                if (subqueries != null && subqueries.length > 0) {
                    positiveNode = new OrNode(subqueries);
                }
            }
        }
        if (prohibitedClauses.size() > 0) {
            negativeNode = prohibitedClauses.size() == 1 ? this.translate((Query)prohibitedClauses.get(0)) : new OrNode(this.translate(prohibitedClauses));
        }
        if (negativeNode == null) {
            return positiveNode;
        }
        if (positiveNode == null) {
            return new UnaryNotNode(negativeNode);
        }
        return new AndNotNode(positiveNode, negativeNode);
    }

    private SectionSearchQueryPlan[] translate(ArrayList<Query> queries) throws IOException {
        int size = queries.size();
        ArrayList<SectionSearchQueryPlan> result = new ArrayList<SectionSearchQueryPlan>(size);
        for (int i = 0; i < size; ++i) {
            SectionSearchQueryPlan plan = this.translate(queries.get(i));
            if (plan == null) continue;
            result.add(plan);
        }
        return result.toArray(new SectionSearchQueryPlan[result.size()]);
    }

    public static class TranslationException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public TranslationException(String message) {
            super(message);
        }
    }
}

