/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.lucene.search.PhrasePositions;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.PhraseQueue;
import org.apache.lucene.search.PhraseScorer;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.search.Weight;

final class SloppyPhraseScorer
extends PhraseScorer {
    private int slop;
    private boolean checkedRepeats;
    private boolean hasRepeats;
    private PhraseQueue pq;
    private PhrasePositions[] nrPps;

    SloppyPhraseScorer(Weight weight, PhraseQuery.PostingsAndFreq[] postings, Similarity similarity, int slop, byte[] norms) {
        super(weight, postings, similarity, norms);
        this.slop = slop;
    }

    protected float phraseFreq() throws IOException {
        int next;
        int end = this.initPhrasePositions();
        if (end == Integer.MIN_VALUE) {
            return 0.0f;
        }
        float freq = 0.0f;
        PhrasePositions pp = (PhrasePositions)this.pq.pop();
        int matchLength = end - pp.position;
        int n = next = this.pq.size() > 0 ? ((PhrasePositions)this.pq.top()).position : pp.position;
        while (pp.nextPosition() && (end = this.advanceRepeats(pp, end)) != Integer.MIN_VALUE) {
            if (pp.position > next) {
                if (matchLength <= this.slop) {
                    freq += this.getSimilarity().sloppyFreq(matchLength);
                }
                this.pq.add(pp);
                pp = (PhrasePositions)this.pq.pop();
                next = this.pq.size() > 0 ? ((PhrasePositions)this.pq.top()).position : pp.position;
                matchLength = end - pp.position;
                continue;
            }
            int matchLength2 = end - pp.position;
            if (matchLength2 >= matchLength) continue;
            matchLength = matchLength2;
        }
        if (matchLength <= this.slop) {
            freq += this.getSimilarity().sloppyFreq(matchLength);
        }
        return freq;
    }

    private int advanceRepeats(PhrasePositions pp, int end) throws IOException {
        int repeatsEnd = end;
        if (pp.position > repeatsEnd) {
            repeatsEnd = pp.position;
        }
        if (!this.hasRepeats) {
            return repeatsEnd;
        }
        int tpPos = this.tpPos(pp);
        PhrasePositions pp2 = pp.nextRepeating;
        while (pp2 != null) {
            while (this.tpPos(pp2) <= tpPos) {
                if (pp2.nextPosition()) continue;
                return Integer.MIN_VALUE;
            }
            tpPos = this.tpPos(pp2);
            if (pp2.position > repeatsEnd) {
                repeatsEnd = pp2.position;
            }
            if (pp2.position < pp.position) {
                pp.position = pp2.position;
            }
            pp2 = pp2.nextRepeating;
        }
        return repeatsEnd;
    }

    private int initPhrasePositions() throws IOException {
        int end = Integer.MIN_VALUE;
        if (this.checkedRepeats && !this.hasRepeats) {
            this.pq.clear();
            PhrasePositions pp = this.min;
            PhrasePositions prev = null;
            while (prev != this.max) {
                pp.firstPosition();
                if (pp.position > end) {
                    end = pp.position;
                }
                this.pq.add(pp);
                prev = pp;
                pp = prev.next;
            }
            return end;
        }
        PhrasePositions pp = this.min;
        PhrasePositions prev = null;
        while (prev != this.max) {
            pp.firstPosition();
            prev = pp;
            pp = prev.next;
        }
        if (!this.checkedRepeats) {
            this.checkedRepeats = true;
            ArrayList<PhrasePositions> ppsA = new ArrayList<PhrasePositions>();
            PhrasePositions dummyPP = new PhrasePositions(null, -1, -1);
            PhrasePositions pp2 = this.min;
            PhrasePositions prev2 = null;
            while (prev2 != this.max) {
                if (pp2.nextRepeating == null) {
                    ppsA.add(pp2);
                    int tpPos = this.tpPos(pp2);
                    PhrasePositions prevB = pp2;
                    PhrasePositions pp22 = pp2.next;
                    while (pp22 != this.min) {
                        if (pp22.nextRepeating == null && pp2.offset != pp22.offset && this.tpPos(pp22) == tpPos) {
                            this.hasRepeats = true;
                            prevB.nextRepeating = pp22;
                            pp22.nextRepeating = dummyPP;
                            prevB = pp22;
                        }
                        pp22 = pp22.next;
                    }
                }
                prev2 = pp2;
                pp2 = prev2.next;
            }
            if (this.hasRepeats) {
                pp2 = this.min;
                prev2 = null;
                while (prev2 != this.max) {
                    if (pp2.nextRepeating == dummyPP) {
                        pp2.nextRepeating = null;
                    }
                    prev2 = pp2;
                    pp2 = prev2.next;
                }
            }
            this.nrPps = ppsA.toArray(new PhrasePositions[0]);
            this.pq = new PhraseQueue(this.nrPps.length);
        }
        if (this.hasRepeats) {
            for (PhrasePositions pp3 : this.nrPps) {
                if ((end = this.advanceRepeats(pp3, end)) != Integer.MIN_VALUE) continue;
                return Integer.MIN_VALUE;
            }
        }
        this.pq.clear();
        for (PhrasePositions pp3 : this.nrPps) {
            if (pp3.position > end) {
                end = pp3.position;
            }
            this.pq.add(pp3);
        }
        return end;
    }

    private final int tpPos(PhrasePositions pp) {
        return pp.position + pp.offset;
    }
}

