/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dataset;

import java.io.IOException;
import ucar.ma2.Array;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Section;
import ucar.ma2.StructureData;
import ucar.ma2.StructureDataIterator;
import ucar.nc2.Group;
import ucar.nc2.Sequence;
import ucar.nc2.dataset.StructureDS;

public class SequenceDS
extends StructureDS {
    private Sequence orgSeq;

    public SequenceDS(Group g, Sequence orgSeq) {
        super(g, orgSeq);
        this.orgSeq = orgSeq;
    }

    public StructureDataIterator getStructureIterator(int bufferSize) throws IOException {
        return new StructureDataConverter(this, this.orgSeq.getStructureIterator(bufferSize));
    }

    public Array read(Section section) throws IOException, InvalidRangeException {
        return this.read();
    }

    public Array read() throws IOException {
        Array data = this.orgSeq.read();
        return this.convert(data, null);
    }

    private class StructureDataConverter
    implements StructureDataIterator {
        private StructureDataIterator orgIter;
        private SequenceDS newStruct;
        private int count = 0;

        StructureDataConverter(SequenceDS newStruct, StructureDataIterator orgIter) {
            this.newStruct = newStruct;
            this.orgIter = orgIter;
        }

        public boolean hasNext() throws IOException {
            return this.orgIter.hasNext();
        }

        public StructureData next() throws IOException {
            StructureData sdata = this.orgIter.next();
            return this.newStruct.convert(sdata, this.count++);
        }

        public void setBufferSize(int bytes) {
            this.orgIter.setBufferSize(bytes);
        }

        public StructureDataIterator reset() {
            this.orgIter.reset();
            return this;
        }

        public int getCurrentRecno() {
            return this.orgIter.getCurrentRecno();
        }
    }
}

