/*
 * Decompiled with CFR 0.152.
 */
package ucar.units;

import ucar.units.BaseQuantity;
import ucar.units.BaseUnit;
import ucar.units.DerivableUnit;
import ucar.units.DerivedUnit;
import ucar.units.MultiplyException;
import ucar.units.NameException;
import ucar.units.OperationException;
import ucar.units.QuantityDimension;
import ucar.units.Unit;
import ucar.units.UnitDimension;
import ucar.units.UnitImpl;
import ucar.units.UnitName;

public class DerivedUnitImpl
extends UnitImpl
implements DerivedUnit,
DerivableUnit {
    private static final long serialVersionUID = 1L;
    public static final DerivedUnitImpl DIMENSIONLESS = new DerivedUnitImpl();
    private UnitDimension dimension;

    protected DerivedUnitImpl() {
        this(new UnitDimension(), DerivedUnitImpl.dimensionlessID());
    }

    private static UnitName dimensionlessID() {
        UnitName id;
        try {
            id = UnitName.newUnitName("1", "1", "1");
        }
        catch (NameException e) {
            id = null;
        }
        return id;
    }

    protected DerivedUnitImpl(UnitDimension dimension) {
        this(dimension, null);
    }

    protected DerivedUnitImpl(UnitName id) {
        this(null, id);
    }

    protected DerivedUnitImpl(UnitDimension dimension, UnitName id) {
        super(id);
        this.dimension = dimension;
    }

    protected void setDimension(UnitDimension dimension) {
        this.dimension = dimension;
    }

    public final UnitDimension getDimension() {
        return this.dimension;
    }

    public final QuantityDimension getQuantityDimension() {
        return this.getDimension().getQuantityDimension();
    }

    public final boolean isReciprocalOf(DerivedUnit that) {
        return this.dimension.isReciprocalOf(that.getDimension());
    }

    public final DerivedUnit getDerivedUnit() {
        return this;
    }

    public final Unit clone(UnitName id) {
        return new DerivedUnitImpl(this.dimension, id);
    }

    protected Unit myMultiplyBy(Unit that) throws MultiplyException {
        UnitDimension thatDimension;
        Unit result = this.dimension.getRank() == 0 ? that : (!(that instanceof DerivedUnit) ? that.multiplyBy(this) : ((thatDimension = ((DerivedUnit)that).getDimension()).getRank() == 0 ? this : new DerivedUnitImpl(this.dimension.multiplyBy(thatDimension))));
        return result;
    }

    protected Unit myDivideBy(Unit that) throws OperationException {
        UnitDimension thatDimension;
        Unit result = this.dimension.getRank() == 0 ? that.raiseTo(-1) : (!(that instanceof DerivedUnit) ? that.divideInto(this) : ((thatDimension = ((DerivedUnit)that).getDimension()).getRank() == 0 ? this : new DerivedUnitImpl(this.dimension.divideBy(thatDimension))));
        return result;
    }

    protected Unit myDivideInto(Unit that) throws OperationException {
        return that.divideBy(this);
    }

    protected Unit myRaiseTo(int power) {
        return power == 1 ? this : new DerivedUnitImpl(this.dimension.raiseTo(power));
    }

    public final float toDerivedUnit(float amount) {
        return amount;
    }

    public final double toDerivedUnit(double amount) {
        return amount;
    }

    public final float[] toDerivedUnit(float[] input, float[] output) {
        if (input != output) {
            System.arraycopy(input, 0, output, 0, input.length);
        }
        return output;
    }

    public final double[] toDerivedUnit(double[] input, double[] output) {
        if (input != output) {
            System.arraycopy(input, 0, output, 0, input.length);
        }
        return output;
    }

    public final float fromDerivedUnit(float amount) {
        return amount;
    }

    public final double fromDerivedUnit(double amount) {
        return amount;
    }

    public final float[] fromDerivedUnit(float[] input, float[] output) {
        return this.toDerivedUnit(input, output);
    }

    public final double[] fromDerivedUnit(double[] input, double[] output) {
        return this.toDerivedUnit(input, output);
    }

    public final boolean isCompatible(Unit that) {
        DerivedUnit unit = that.getDerivedUnit();
        return this.equals(unit) || this.isReciprocalOf(unit);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof DerivedUnit)) {
            return false;
        }
        DerivedUnit that = (DerivedUnit)object;
        return this instanceof BaseUnit && that instanceof BaseUnit ? false : this.dimension.equals(that.getDimension());
    }

    public int hashCode() {
        return this instanceof BaseUnit ? System.identityHashCode(this) : this.dimension.hashCode();
    }

    public boolean isDimensionless() {
        return this.dimension.isDimensionless();
    }

    public String toString() {
        String string = super.toString();
        return string != null ? string : this.getCanonicalString();
    }

    public String getCanonicalString() {
        return this.dimension.toString();
    }

    public static void main(String[] args) throws Exception {
        BaseUnit second = BaseUnit.getOrCreate(UnitName.newUnitName("second", null, "s"), BaseQuantity.TIME);
        System.out.println("second = \"" + second + '\"');
        BaseUnit meter = BaseUnit.getOrCreate(UnitName.newUnitName("meter", null, "m"), BaseQuantity.LENGTH);
        System.out.println("meter = \"" + meter + '\"');
        DerivedUnitImpl meterSecond = (DerivedUnitImpl)meter.myMultiplyBy(second);
        System.out.println("meterSecond = \"" + meterSecond + '\"');
        DerivedUnitImpl meterPerSecond = (DerivedUnitImpl)meter.myDivideBy(second);
        System.out.println("meterPerSecond = \"" + meterPerSecond + '\"');
        DerivedUnitImpl secondPerMeter = (DerivedUnitImpl)second.myDivideBy(meter);
        System.out.println("secondPerMeter = \"" + secondPerMeter + '\"');
        System.out.println("meterPerSecond.isReciprocalOf(secondPerMeter)=" + meterPerSecond.isReciprocalOf(secondPerMeter));
        System.out.println("meter.toDerivedUnit(1.0)=" + meter.toDerivedUnit(1.0));
        System.out.println("meter.toDerivedUnit(new double[] {1,2,3}, new double[3])[1]=" + meter.toDerivedUnit(new double[]{1.0, 2.0, 3.0}, new double[3])[1]);
        System.out.println("meter.fromDerivedUnit(1.0)=" + meter.fromDerivedUnit(1.0));
        System.out.println("meter.fromDerivedUnit(new double[] {1,2,3}, new double[3])[2]=" + meter.fromDerivedUnit(new double[]{1.0, 2.0, 3.0}, new double[3])[2]);
        System.out.println("meter.isCompatible(meter)=" + meter.isCompatible(meter));
        System.out.println("meter.isCompatible(second)=" + meter.isCompatible(second));
        System.out.println("meter.equals(meter)=" + meter.equals(meter));
        System.out.println("meter.equals(second)=" + meter.equals(second));
        System.out.println("meter.isDimensionless()=" + meter.isDimensionless());
        Unit sPerS = second.myDivideBy(second);
        System.out.println("sPerS = \"" + sPerS + '\"');
        System.out.println("sPerS.isDimensionless()=" + sPerS.isDimensionless());
        meterPerSecond.raiseTo(2);
        meter.myDivideBy(meterPerSecond);
    }
}

