/*
 * Decompiled with CFR 0.152.
 */
package it.eng.rdlab.soa3.connector.utils;

import it.eng.rdlab.soa3.connector.utils.security.InheritableTLSSLSocketFactory;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMReader;
import org.bouncycastle.openssl.PasswordFinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecurityManager {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    public static final String KEYSTORE_PWD = "changeit";
    private static SecurityManager instance;
    public static final String DEFAULT_CERT_FILE = "/etc/grid-security/hostcert.pem";
    public static final String DEFAULT_KEY_FILE = "/etc/grid-security/hostkey.pem";
    public static final String DEFAULT_TRUST_DIR = "/etc/grid-security/certificates/";
    public static final String DEFAULT_TRUST_FILE_EXTENSION = ".0";
    private KeyStore keyStore;
    private String certFile;
    private String keyFile;
    private String trustDir;
    private String trustExt;
    private InternalPasswordFinder internalPasswordFinder;
    private boolean invalidateTrustDirectory;
    private List<String> trustedCertificates;

    private SecurityManager() {
        Security.addProvider((Provider)new BouncyCastleProvider());
        this.certFile = DEFAULT_CERT_FILE;
        this.keyFile = DEFAULT_KEY_FILE;
        this.trustDir = DEFAULT_TRUST_DIR;
        this.trustExt = DEFAULT_TRUST_FILE_EXTENSION;
        this.internalPasswordFinder = new InternalPasswordFinder();
        this.invalidateTrustDirectory = false;
        this.trustedCertificates = new ArrayList<String>();
        this.keyStore = null;
    }

    public static SecurityManager getInstance() {
        if (instance == null) {
            instance = new SecurityManager();
        }
        return instance;
    }

    public void setCertFile(String certFile) {
        if (certFile != null) {
            this.certFile = certFile;
        }
    }

    public void setPrivateKeyPassword(char[] password) {
        this.internalPasswordFinder.privateKeyPassword = password;
    }

    public void setKeyFile(String keyFile) {
        if (keyFile != null) {
            this.keyFile = keyFile;
        }
    }

    public void setTrustDir(String trustDir) {
        if (trustDir != null) {
            if (!trustDir.endsWith("/")) {
                trustDir = trustDir + "/";
            }
            this.trustDir = trustDir;
        }
    }

    public void setTrustExt(String trustExt) {
        if (trustExt != null) {
            this.trustExt = trustExt;
        }
    }

    public String getCertFile() {
        return this.certFile;
    }

    public String getKeyFile() {
        return this.keyFile;
    }

    public String getTrustDir() {
        return this.trustDir;
    }

    public void invalidateTrustedDir(boolean invalidate) {
        this.invalidateTrustDirectory = invalidate;
    }

    public void addTrustedCert(String file) {
        this.trustedCertificates.add(file);
    }

    private KeyStore generateKeyStore() throws Exception {
        this.log.debug("Getting keystore");
        this.log.debug("Cert file " + this.certFile);
        FileReader reader = new FileReader(this.certFile);
        PEMReader pem = new PEMReader((Reader)reader);
        X509Certificate cert = (X509Certificate)pem.readObject();
        pem.close();
        reader.close();
        this.log.debug("Cert file loaded");
        this.log.debug("Key file " + this.keyFile);
        reader = new FileReader(this.keyFile);
        pem = new PEMReader((Reader)reader, (PasswordFinder)this.internalPasswordFinder);
        PrivateKey key = ((KeyPair)pem.readObject()).getPrivate();
        pem.close();
        reader.close();
        this.log.debug("Key file loaded");
        KeyStore keystore = KeyStore.getInstance(KeyStore.getDefaultType());
        keystore.load(null);
        keystore.setKeyEntry("certs", key, KEYSTORE_PWD.toCharArray(), new Certificate[]{cert});
        List<String> trustedCertFiles = this.getTrustedCerts();
        this.log.debug("trusted files");
        for (int i = 0; i < trustedCertFiles.size(); ++i) {
            this.log.debug(trustedCertFiles.get(i));
            reader = new FileReader(trustedCertFiles.get(i));
            pem = new PEMReader((Reader)reader);
            X509Certificate trustCert = (X509Certificate)pem.readObject();
            pem.close();
            reader.close();
            keystore.setCertificateEntry("trust" + i, trustCert);
        }
        return keystore;
    }

    private List<String> getTrustedCerts() {
        ArrayList<String> response = new ArrayList<String>(this.trustedCertificates);
        if (!this.invalidateTrustDirectory) {
            this.log.debug("Reading the trust directory");
            File dir = new File(this.trustDir);
            String[] fileNames = dir.list();
            this.log.debug("Files in the trust directory");
            for (String fileName : fileNames) {
                this.log.debug(fileName);
                if (!fileName.endsWith(this.trustExt)) continue;
                response.add(this.trustDir + fileName);
            }
        }
        return response;
    }

    public void loadCertificate() throws Exception {
        this.loadCertificate(true);
    }

    public void loadCertificate(boolean threadLocal) throws Exception {
        this.log.debug("Loading certificates...");
        this.log.debug("Loading keystore...");
        this.keyStore = this.generateKeyStore();
        this.log.debug("Keystore loaded");
        KeyManagerFactory keyFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        keyFactory.init(this.keyStore, KEYSTORE_PWD.toCharArray());
        this.log.debug("Initializing trust manager");
        TrustManagerFactory trustFactory = TrustManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        trustFactory.init(this.keyStore);
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(keyFactory.getKeyManagers(), trustFactory.getTrustManagers(), new SecureRandom());
        SSLSocketFactory sslSocketFactory = sslContext.getSocketFactory();
        if (threadLocal) {
            this.log.debug("Generating inheritable thread local ssl factory");
            InheritableTLSSLSocketFactory.getInstance().setSSLSocketFactory(sslSocketFactory);
            sslSocketFactory = InheritableTLSSLSocketFactory.getInstance();
        } else {
            this.log.debug("Generated not thread local ssl factory");
        }
        HttpsURLConnection.setDefaultSSLSocketFactory(sslSocketFactory);
        this.log.debug("Operation completed");
    }

    public void removeCertificate() {
        InheritableTLSSLSocketFactory.getInstance().reset();
    }

    public KeyStore getKeyStore() {
        return this.keyStore;
    }

    public static void main(String[] args) throws Exception {
        System.out.println(new Date());
        SecurityManager menager = new SecurityManager();
        menager.setTrustDir("/home/ciro/certs");
        menager.loadCertificate();
    }

    private class InternalPasswordFinder
    implements PasswordFinder {
        char[] privateKeyPassword = null;

        private InternalPasswordFinder() {
        }

        public char[] getPassword() {
            return this.privateKeyPassword;
        }
    }
}

