/*
 * Decompiled with CFR 0.152.
 */
package com.germinus.easyconf;

import java.util.HashMap;
import java.util.Map;

public class Filter {
    private String[] selectors;
    private Map variables;

    private Filter(String[] selectors) {
        this.selectors = selectors;
    }

    private Filter(Map variables) {
        this.variables = variables;
    }

    public static Filter by(String first) {
        return new Filter(new String[]{first});
    }

    public static Filter by(String first, String second) {
        return new Filter(new String[]{first, second});
    }

    public static Filter by(String first, String second, String third) {
        return new Filter(new String[]{first, second, third});
    }

    public static Filter by(String[] selectors) {
        return new Filter(selectors);
    }

    public static Filter usingVariables(String var1, String value1) {
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put(var1, value1);
        return new Filter(vars);
    }

    public static Filter usingVariables(String var1, String value1, String var2, String value2) {
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put(var1, value1);
        vars.put(var2, value2);
        return new Filter(vars);
    }

    public static Filter usingVariables(String var1, String value1, String var2, String value2, String var3, String value3) {
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put(var1, value1);
        vars.put(var2, value2);
        vars.put(var3, value3);
        return new Filter(vars);
    }

    public static Filter usingVariables(Map vars) {
        return new Filter(vars);
    }

    public boolean hasVariables() {
        return this.variables != null && !this.variables.isEmpty();
    }

    public Filter setVariables(Map newVars) {
        this.variables = newVars;
        return this;
    }

    public Map getVariables() {
        return this.variables;
    }

    public String[] getSelectors() {
        return this.selectors;
    }

    public Filter setSelectors(String[] newSelectors) {
        this.selectors = newSelectors;
        return this;
    }

    public int numOfSelectors() {
        if (this.selectors == null) {
            return 0;
        }
        return this.selectors.length;
    }

    public String getFilterSuffix(int n) {
        if (n < 0 || n > this.numOfSelectors()) {
            throw new IllegalArgumentException("Imposible to obtain filter fragment for n=" + n);
        }
        if (n == 0) {
            return "";
        }
        StringBuffer filter = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            filter.append('[');
            filter.append(this.selectors[i]);
            filter.append(']');
        }
        return filter.toString();
    }

    public String toString() {
        return this.getFilterSuffix(this.numOfSelectors());
    }
}

