/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.rights;

import org.hsqldb.Database;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.Routine;
import org.hsqldb.Schema;
import org.hsqldb.Session;
import org.hsqldb.error.Error;
import org.hsqldb.lib.HashMappedList;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.result.Result;
import org.hsqldb.rights.Grantee;
import org.hsqldb.rights.GranteeManager;
import org.hsqldb.rights.User;

public final class UserManager {
    private HashMappedList userList;
    private GranteeManager granteeManager;
    Routine pwCheckFunction;
    Routine extAuthenticationFunction;

    public UserManager(Database database) {
        this.granteeManager = database.getGranteeManager();
        this.userList = new HashMappedList();
    }

    public User createUser(HsqlNameManager.HsqlName name, String password, boolean isDigest) {
        User user = this.granteeManager.addUser(name);
        user.setPassword(password, isDigest);
        boolean success = this.userList.add(name.name, user);
        if (!success) {
            throw Error.error(4003, name.statementName);
        }
        return user;
    }

    public void setPassword(Session session, User user, String password) {
        if (!this.checkComplexity(session, password)) {
            throw Error.error(391);
        }
        user.setPassword(password, false);
    }

    public boolean checkComplexity(Session session, String password) {
        if (session == null || this.pwCheckFunction == null) {
            return true;
        }
        Result result = this.pwCheckFunction.invoke(session, new Object[]{password}, null, false);
        Boolean check = (Boolean)result.getValueObject();
        return check != null && check != false;
    }

    public void dropUser(String name) {
        boolean reservedUser = GranteeManager.isReserved(name);
        if (reservedUser) {
            throw Error.error(4002, name);
        }
        boolean result = this.granteeManager.removeGrantee(name);
        if (!result) {
            throw Error.error(4001, name);
        }
        User user = (User)this.userList.remove(name);
        if (user == null) {
            throw Error.error(4001, name);
        }
    }

    public void createFirstUser(String username, String password) {
        boolean isQuoted = true;
        if (username.equalsIgnoreCase("SA")) {
            username = "SA";
            isQuoted = false;
        }
        HsqlNameManager.HsqlName name = this.granteeManager.database.nameManager.newHsqlName(username, isQuoted, 11);
        User user = this.createUser(name, password, false);
        user.isLocalOnly = true;
        this.granteeManager.grant(name.name, "DBA", this.granteeManager.getDBARole());
    }

    public User getUser(String name, String password) {
        int i;
        User user;
        boolean isLocal;
        if (name == null) {
            name = "";
        }
        if (password == null) {
            password = "";
        }
        boolean bl = isLocal = (user = (User)this.userList.get(name)) != null && user.isLocalOnly;
        if (this.extAuthenticationFunction == null || isLocal) {
            user = this.get(name);
            user.checkPassword(password);
            return user;
        }
        Result result = this.extAuthenticationFunction.invokeJavaMethodDirect(new String[]{this.granteeManager.database.getUniqueName(), name, password});
        if (result.isError()) {
            throw Error.error(4001, result.getMainString());
        }
        Object[] roles = (Object[])result.getValueObject();
        if (user == null) {
            HsqlNameManager.HsqlName hsqlName = this.granteeManager.database.nameManager.newHsqlName(name, true, 11);
            user = this.createUser(hsqlName, "", false);
            user.isExternalOnly = true;
        }
        if (roles == null) {
            user.updateAllRights();
            return user;
        }
        user.clearPrivileges();
        for (i = 0; i < roles.length; ++i) {
            try {
                Grantee role = this.granteeManager.getRole((String)roles[i]);
                user.grant(role);
                continue;
            }
            catch (HsqlException e) {
                // empty catch block
            }
        }
        user.updateAllRights();
        for (i = 0; i < roles.length; ++i) {
            Schema schema = this.granteeManager.database.schemaManager.findSchema((String)roles[i]);
            if (schema == null) continue;
            user.setInitialSchema(schema.getName());
            break;
        }
        return user;
    }

    public HashMappedList getUsers() {
        return this.userList;
    }

    public boolean exists(String name) {
        return this.userList.get(name) != null;
    }

    public User get(String name) {
        User user = (User)this.userList.get(name);
        if (user == null) {
            throw Error.error(4001, name);
        }
        return user;
    }

    public HsqlArrayList listVisibleUsers(Session session) {
        HsqlArrayList list = new HsqlArrayList();
        boolean isAdmin = session.isAdmin();
        String sessionName = session.getUsername();
        if (this.userList == null || this.userList.size() == 0) {
            return list;
        }
        for (int i = 0; i < this.userList.size(); ++i) {
            User user = (User)this.userList.get(i);
            if (user == null) continue;
            String userName = user.getName().getNameString();
            if (isAdmin) {
                list.add(user);
                continue;
            }
            if (!sessionName.equals(userName)) continue;
            list.add(user);
        }
        return list;
    }

    public User getSysUser() {
        return GranteeManager.systemAuthorisation;
    }

    public synchronized void removeSchemaReference(String schemaName) {
        for (int i = 0; i < this.userList.size(); ++i) {
            User user = (User)this.userList.get(i);
            HsqlNameManager.HsqlName schema = user.getInitialSchema();
            if (schema == null || !schemaName.equals(schema.name)) continue;
            user.setInitialSchema(null);
        }
    }

    public void setPasswordCheckFunction(Routine function) {
        this.pwCheckFunction = function;
    }

    public void setExtAuthenticationFunction(Routine function) {
        this.extAuthenticationFunction = function;
    }

    public String[] getInitialSchemaSQL() {
        HsqlArrayList list = new HsqlArrayList(this.userList.size());
        for (int i = 0; i < this.userList.size(); ++i) {
            HsqlNameManager.HsqlName name;
            User user = (User)this.userList.get(i);
            if (user.isSystem || (name = user.getInitialSchema()) == null) continue;
            list.add(user.getInitialSchemaSQL());
        }
        String[] array = new String[list.size()];
        list.toArray(array);
        return array;
    }

    public String[] getAuthenticationSQL() {
        StringBuffer sb;
        HsqlArrayList list = new HsqlArrayList();
        if (this.pwCheckFunction != null) {
            sb = new StringBuffer();
            sb.append("SET").append(' ').append("DATABASE");
            sb.append(' ').append("PASSWORD").append(' ');
            sb.append("CHECK").append(' ').append("FUNCTION");
            sb.append(' ');
            sb.append(this.pwCheckFunction.getSQLBodyDefinition());
            list.add(sb.toString());
        }
        if (this.extAuthenticationFunction != null) {
            sb = new StringBuffer();
            sb.append("SET").append(' ').append("DATABASE");
            sb.append(' ').append("AUTHENTICATION").append(' ');
            sb.append("FUNCTION").append(' ');
            sb.append(this.extAuthenticationFunction.getSQLBodyDefinition());
            list.add(sb.toString());
        }
        String[] array = new String[list.size()];
        list.toArray(array);
        return array;
    }
}

