/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.rowio;

import java.io.IOException;
import java.math.BigDecimal;
import org.hsqldb.HsqlException;
import org.hsqldb.error.Error;
import org.hsqldb.lib.HsqlByteArrayInputStream;
import org.hsqldb.types.BinaryData;
import org.hsqldb.types.BlobData;
import org.hsqldb.types.ClobData;
import org.hsqldb.types.IntervalMonthData;
import org.hsqldb.types.IntervalSecondData;
import org.hsqldb.types.TimeData;
import org.hsqldb.types.TimestampData;
import org.hsqldb.types.Type;

abstract class RowInputBase
extends HsqlByteArrayInputStream {
    static final int NO_POS = -1;
    protected int filePos = -1;
    protected int size;

    RowInputBase() {
        this(new byte[4]);
    }

    RowInputBase(byte[] buf) {
        super(buf);
        this.size = buf.length;
    }

    public int getPos() {
        if (this.filePos == -1) {
            // empty if block
        }
        return this.filePos;
    }

    public int getSize() {
        return this.size;
    }

    public abstract int readType() throws IOException;

    public abstract String readString() throws IOException;

    protected abstract boolean readNull() throws IOException;

    protected abstract String readChar(Type var1) throws IOException;

    protected abstract Integer readSmallint() throws IOException;

    protected abstract Integer readInteger() throws IOException;

    protected abstract Long readBigint() throws IOException;

    protected abstract Double readReal() throws IOException;

    protected abstract BigDecimal readDecimal(Type var1) throws IOException;

    protected abstract Boolean readBoole() throws IOException;

    protected abstract TimeData readTime(Type var1) throws IOException;

    protected abstract TimestampData readDate(Type var1) throws IOException;

    protected abstract TimestampData readTimestamp(Type var1) throws IOException;

    protected abstract IntervalMonthData readYearMonthInterval(Type var1) throws IOException;

    protected abstract IntervalSecondData readDaySecondInterval(Type var1) throws IOException;

    protected abstract Object readOther() throws IOException;

    protected abstract BinaryData readBinary() throws IOException, HsqlException;

    protected abstract BinaryData readBit() throws IOException;

    protected abstract ClobData readClob() throws IOException;

    protected abstract BlobData readBlob() throws IOException;

    protected abstract Object[] readArray(Type var1) throws IOException;

    public Object[] readData(Type[] colTypes) throws IOException {
        int l = colTypes.length;
        Object[] data = new Object[l];
        for (int i = 0; i < l; ++i) {
            Type type = colTypes[i];
            data[i] = this.readData(type);
        }
        return data;
    }

    public Object readData(Type type) throws IOException {
        Object[] o = null;
        if (this.readNull()) {
            return null;
        }
        switch (type.typeCode) {
            case 0: {
                break;
            }
            case 1: 
            case 12: 
            case 100: {
                o = this.readChar(type);
                break;
            }
            case -6: 
            case 5: {
                o = this.readSmallint();
                break;
            }
            case 4: {
                o = this.readInteger();
                break;
            }
            case 25: {
                o = this.readBigint();
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                o = this.readReal();
                break;
            }
            case 2: 
            case 3: {
                o = this.readDecimal(type);
                break;
            }
            case 91: {
                o = this.readDate(type);
                break;
            }
            case 92: 
            case 94: {
                o = this.readTime(type);
                break;
            }
            case 93: 
            case 95: {
                o = this.readTimestamp(type);
                break;
            }
            case 101: 
            case 102: 
            case 107: {
                o = this.readYearMonthInterval(type);
                break;
            }
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: {
                o = this.readDaySecondInterval(type);
                break;
            }
            case 16: {
                o = this.readBoole();
                break;
            }
            case 1111: {
                o = this.readOther();
                break;
            }
            case 40: {
                o = this.readClob();
                break;
            }
            case 30: {
                o = this.readBlob();
                break;
            }
            case 50: {
                o = this.readArray(type);
                break;
            }
            case 60: 
            case 61: {
                o = this.readBinary();
                break;
            }
            case 14: 
            case 15: {
                o = this.readBit();
                break;
            }
            default: {
                throw Error.runtimeError(201, "RowInputBase - " + type.getNameString());
            }
        }
        return o;
    }

    public void resetRow(int filepos, int rowsize) throws IOException {
        this.mark = 0;
        this.reset();
        if (this.buffer.length < rowsize) {
            this.buffer = new byte[rowsize];
        }
        this.filePos = filepos;
        this.size = this.count = rowsize;
        this.pos = 4;
        this.buffer[0] = (byte)(rowsize >>> 24 & 0xFF);
        this.buffer[1] = (byte)(rowsize >>> 16 & 0xFF);
        this.buffer[2] = (byte)(rowsize >>> 8 & 0xFF);
        this.buffer[3] = (byte)(rowsize >>> 0 & 0xFF);
    }

    public byte[] getBuffer() {
        return this.buffer;
    }

    public int skipBytes(int n) throws IOException {
        throw Error.runtimeError(201, "RowInputBase");
    }

    public String readLine() throws IOException {
        throw Error.runtimeError(201, "RowInputBase");
    }
}

