/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import com.sun.jmx.mbeanserver.GetPropertyAction;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.security.AccessController;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.WeakHashMap;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.QueryExp;

public class ObjectName
implements QueryExp,
Serializable {
    private static final long oldSerialVersionUID = -5467795090068647408L;
    private static final long newSerialVersionUID = 1081892073854801359L;
    private static final ObjectStreamField[] oldSerialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("domain", class$java$lang$String == null ? (class$java$lang$String = ObjectName.class$("java.lang.String")) : class$java$lang$String), new ObjectStreamField("propertyList", class$java$util$Hashtable == null ? (class$java$util$Hashtable = ObjectName.class$("java.util.Hashtable")) : class$java$util$Hashtable), new ObjectStreamField("propertyListString", class$java$lang$String == null ? (class$java$lang$String = ObjectName.class$("java.lang.String")) : class$java$lang$String), new ObjectStreamField("canonicalName", class$java$lang$String == null ? (class$java$lang$String = ObjectName.class$("java.lang.String")) : class$java$lang$String), new ObjectStreamField("pattern", Boolean.TYPE), new ObjectStreamField("propertyPattern", Boolean.TYPE)};
    private static final ObjectStreamField[] newSerialPersistentFields = new ObjectStreamField[0];
    private static final long serialVersionUID;
    private static final ObjectStreamField[] serialPersistentFields;
    private static boolean compat;
    private static final Property[] _Empty_property_array;
    private static final Hashtable _EmptyPropertyList;
    private transient String _canonicalName;
    private transient Property[] _kp_array;
    private transient Property[] _ca_array;
    private transient int _domain_length = 0;
    private transient Hashtable _propertyList;
    private transient boolean _domain_pattern = false;
    private transient boolean _property_pattern = false;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$util$Hashtable;
    static /* synthetic */ Class class$javax$management$ObjectName;

    private void construct(String string) throws MalformedObjectNameException {
        char c;
        if (string == null) {
            throw new MalformedObjectNameException("Invalid name: cannot be null");
        }
        if (string.length() == 0) {
            this._canonicalName = "*:*";
            this._kp_array = _Empty_property_array;
            this._ca_array = _Empty_property_array;
            this._domain_length = 1;
            this._propertyList = null;
            this._domain_pattern = true;
            this._property_pattern = true;
            return;
        }
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        char[] cArray2 = new char[n];
        int n2 = 0;
        int n3 = 0;
        block18: while (n3 < n) {
            c = cArray[n3];
            switch (c) {
                case ':': {
                    this._domain_length = n3++;
                    break block18;
                }
                case '=': {
                    int n4 = ++n3;
                    while (n4 < n && cArray[n4++] != ':') {
                        if (n4 != n) continue;
                        throw new MalformedObjectNameException("Domain part must be specified");
                    }
                    continue block18;
                }
                case '\n': {
                    throw new MalformedObjectNameException("Invalid character '\\n' in domain name");
                }
                case '*': 
                case '?': {
                    this._domain_pattern = true;
                }
                default: {
                    ++n3;
                    continue block18;
                }
            }
        }
        if (n3 == n) {
            throw new MalformedObjectNameException("Key properties cannot be empty");
        }
        System.arraycopy(cArray, 0, cArray2, 0, this._domain_length);
        cArray2[this._domain_length] = 58;
        n2 = this._domain_length + 1;
        PropertyLengthCouple propertyLengthCouple = new PropertyLengthCouple(-1, -1);
        HashMap hashMap = new HashMap();
        int n5 = 0;
        String[] stringArray = new String[10];
        this._kp_array = new Property[10];
        this._property_pattern = false;
        while (n3 < n) {
            int n6;
            boolean bl;
            String[] stringArray2;
            char c2;
            int n7;
            c = cArray[n3];
            if (c == '*') {
                if (this._property_pattern) {
                    throw new MalformedObjectNameException("Cannot have several '*' characters in pattern properties");
                }
                this._property_pattern = true;
                if (++n3 < n && cArray[n3] != ',') {
                    throw new MalformedObjectNameException("Invalid character found after '*': end of name or ',' expected");
                }
                if (n3 == n) {
                    if (n5 != 0) break;
                    this._kp_array = _Empty_property_array;
                    this._ca_array = _Empty_property_array;
                    this._propertyList = _EmptyPropertyList;
                    break;
                }
                ++n3;
                continue;
            }
            int n8 = n7 = n3;
            while (n7 < n && (c2 = cArray[n7++]) != '=') {
                switch (c2) {
                    case '\n': 
                    case '*': 
                    case ',': 
                    case ':': 
                    case '?': {
                        stringArray2 = c2 == '\n' ? "\\n" : "" + c2;
                        throw new MalformedObjectNameException("Invalid character '" + (String)stringArray2 + "' in key part part of property");
                    }
                }
            }
            if (n7 == n) {
                throw new MalformedObjectNameException("Unterminated key property part");
            }
            if (n7 == n3) {
                throw new MalformedObjectNameException("Invalid key (empty)");
            }
            int n9 = n7;
            int n10 = n9 - n8 - 1;
            if (cArray[n7] == '\"') {
                bl = true;
                block22: while (++n7 < n && (c2 = cArray[n7]) != '\"') {
                    if (c2 == '\\') {
                        if (++n7 == n) {
                            throw new MalformedObjectNameException("Unterminated quoted value");
                        }
                        c2 = cArray[n7];
                        switch (c2) {
                            case '\"': 
                            case '*': 
                            case '?': 
                            case '\\': 
                            case 'n': {
                                continue block22;
                            }
                        }
                        throw new MalformedObjectNameException("Invalid escape sequence '\\" + c2 + "' in quoted value");
                    }
                    if (c2 == '\n') {
                        throw new MalformedObjectNameException("Newline in quoted value");
                    }
                    switch (c2) {
                        case '*': 
                        case '?': {
                            throw new MalformedObjectNameException("Invalid unescaped reserved character '" + c2 + "' in quoted value");
                        }
                    }
                }
                if (n7 == n) {
                    throw new MalformedObjectNameException("Unterminated quoted value");
                }
                n6 = ++n7 - n9;
            } else {
                bl = false;
                while (n7 < n && (c2 = cArray[n7]) != ',') {
                    switch (c2) {
                        case '\n': 
                        case '\"': 
                        case '*': 
                        case ':': 
                        case '=': 
                        case '?': {
                            stringArray2 = c2 == '\n' ? "\\n" : "" + c2;
                            throw new MalformedObjectNameException("Invalid character '" + c2 + "' in value part of property");
                        }
                    }
                    ++n7;
                }
                n6 = n7 - n9;
            }
            if (n7 == n - 1) {
                if (bl) {
                    throw new MalformedObjectNameException("Invalid ending character `" + cArray[n7] + "'");
                }
                throw new MalformedObjectNameException("Invalid ending comma");
            }
            ++n7;
            propertyLengthCouple.setLengths(n10, n6);
            Property property = new Property(n8, propertyLengthCouple);
            String string2 = string.substring(n8, n8 + n10);
            if (n5 == stringArray.length) {
                stringArray2 = new String[n5 + 10];
                System.arraycopy(stringArray, 0, stringArray2, 0, n5);
                stringArray = stringArray2;
            }
            stringArray[n5] = string2;
            this.addProperty(property, n5, hashMap, string2);
            ++n5;
            n3 = n7;
        }
        this.setCanonicalName(cArray, cArray2, stringArray, hashMap, n2, n5);
    }

    private void construct(String string, Hashtable hashtable) throws MalformedObjectNameException {
        Object object;
        Object object2;
        if (string == null) {
            throw new MalformedObjectNameException("Domain part must be specified");
        }
        if (hashtable == null) {
            throw new MalformedObjectNameException("Property list cannot be empty");
        }
        if (!this.isDomain(string)) {
            throw new MalformedObjectNameException("Invalid domain: " + string);
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string).append(':');
        this._domain_length = string.length();
        int n = hashtable.size();
        this._kp_array = new Property[n];
        PropertyLengthCouple propertyLengthCouple = new PropertyLengthCouple(-1, -1);
        String[] stringArray = new String[n];
        Enumeration enumeration = hashtable.keys();
        HashMap hashMap = new HashMap();
        int n2 = 0;
        while (enumeration.hasMoreElements()) {
            if (n2 > 0) {
                stringBuffer.append(",");
            }
            object2 = "";
            try {
                object2 = (String)enumeration.nextElement();
            }
            catch (Exception exception) {
                throw new MalformedObjectNameException("Invalid key `" + (String)object2 + "'");
            }
            object = "";
            try {
                object = (String)hashtable.get(object2);
            }
            catch (Exception exception) {
                throw new MalformedObjectNameException("Invalid value `" + (String)object + "'");
            }
            int n3 = stringBuffer.length();
            this.checkKey((String)object2);
            stringBuffer.append((String)object2);
            stringArray[n2] = object2;
            stringBuffer.append("=");
            this.checkValue((String)object);
            stringBuffer.append((String)object);
            propertyLengthCouple.setLengths(((String)object2).length(), ((String)object).length());
            Property property = new Property(n3, propertyLengthCouple);
            this.addProperty(property, n2, hashMap, (String)object2);
            ++n2;
        }
        n2 = stringBuffer.length();
        object2 = new char[n2];
        stringBuffer.getChars(0, n2, (char[])object2, 0);
        object = new char[n2];
        System.arraycopy(object2, 0, object, 0, this._domain_length + 1);
        this.setCanonicalName((char[])object2, (char[])object, stringArray, hashMap, this._domain_length + 1, this._kp_array.length);
    }

    private void addProperty(Property property, int n, HashMap hashMap, String string) throws MalformedObjectNameException {
        if (hashMap.containsKey(string)) {
            throw new MalformedObjectNameException("key `" + string + "' already defined");
        }
        if (n == this._kp_array.length) {
            Property[] propertyArray = new Property[n + 10];
            System.arraycopy(this._kp_array, 0, propertyArray, 0, n);
            this._kp_array = propertyArray;
        }
        this._kp_array[n] = property;
        hashMap.put(string, property);
    }

    private void setCanonicalName(char[] cArray, char[] cArray2, String[] objectArray, HashMap hashMap, int n, int n2) {
        if (this._kp_array != _Empty_property_array) {
            int n3;
            Object[] objectArray2 = new String[n2];
            Property[] propertyArray = new Property[n2];
            System.arraycopy(objectArray, 0, objectArray2, 0, n2);
            Arrays.sort(objectArray2);
            objectArray = objectArray2;
            System.arraycopy(this._kp_array, 0, propertyArray, 0, n2);
            this._kp_array = propertyArray;
            this._ca_array = new Property[n2];
            for (n3 = 0; n3 < n2; ++n3) {
                this._ca_array[n3] = (Property)hashMap.get(objectArray[n3]);
            }
            n3 = n2 - 1;
            for (int i = 0; i <= n3; ++i) {
                Property property = this._ca_array[i];
                int n4 = property._lengths._key_length + property._lengths._value_length + 1;
                System.arraycopy(cArray, property._key_index, cArray2, n, n4);
                property.setKeyIndex(n);
                n += n4;
                if (i == n3) continue;
                cArray2[n] = 44;
                ++n;
            }
        }
        if (this._property_pattern) {
            if (this._kp_array != _Empty_property_array) {
                cArray2[n++] = 44;
            }
            cArray2[n++] = 42;
        }
        this._canonicalName = new String(cArray2, 0, n).intern();
    }

    private static final int parseKey(char[] cArray, int n) throws MalformedObjectNameException {
        int n2 = n;
        int n3 = n;
        int n4 = cArray.length;
        block4: while (n2 < n4) {
            char c = cArray[n2++];
            switch (c) {
                case '\n': 
                case '*': 
                case ',': 
                case ':': 
                case '?': {
                    String string = c == '\n' ? "\\n" : "" + c;
                    throw new MalformedObjectNameException("Invalid character in key: `" + string + "'");
                }
                case '=': {
                    n3 = n2 - 1;
                    break block4;
                }
                default: {
                    if (n2 < n4) continue block4;
                    n3 = n2;
                    break block4;
                }
            }
        }
        return n3;
    }

    private static final int parseValue(char[] cArray, int n) throws MalformedObjectNameException {
        int n2;
        block22: {
            int n3;
            int n4;
            block19: {
                n4 = n;
                n2 = n;
                n3 = cArray.length;
                char c = cArray[n];
                if (c != '\"') break block19;
                if (++n4 == n3) {
                    throw new MalformedObjectNameException("Invalid quote");
                }
                while (n4 < n3) {
                    char c2;
                    block21: {
                        block20: {
                            c2 = cArray[n4];
                            if (c2 != '\\') break block20;
                            if (++n4 == n3) {
                                throw new MalformedObjectNameException("Invalid unterminated quoted character sequence");
                            }
                            c2 = cArray[n4];
                            switch (c2) {
                                case '*': 
                                case '?': 
                                case '\\': 
                                case 'n': {
                                    break block21;
                                }
                                case '\"': {
                                    if (n4 + 1 == n3) {
                                        throw new MalformedObjectNameException("Missing termination quote");
                                    }
                                    break block21;
                                }
                                default: {
                                    throw new MalformedObjectNameException("Invalid quoted character sequence '\\" + c2 + "'");
                                }
                            }
                        }
                        if (c2 == '\n') {
                            throw new MalformedObjectNameException("Newline in quoted value");
                        }
                        if (c2 == '\"') {
                            ++n4;
                            break;
                        }
                        switch (c2) {
                            case '*': 
                            case '?': {
                                throw new MalformedObjectNameException("Invalid unescaped reserved character '" + c2 + "' in quoted value");
                            }
                        }
                    }
                    if (++n4 < n3 || c2 == '\"') continue;
                    throw new MalformedObjectNameException("Missing termination quote");
                }
                n2 = n4;
                if (n4 < n3 && cArray[n4++] != ',') {
                    throw new MalformedObjectNameException("Invalid quote");
                }
                break block22;
            }
            block12: while (n4 < n3) {
                char c = cArray[n4++];
                switch (c) {
                    case '\n': 
                    case '*': 
                    case ':': 
                    case '=': 
                    case '?': {
                        String string = c == '\n' ? "\\n" : "" + c;
                        throw new MalformedObjectNameException("Invalid character `" + string + "' in value");
                    }
                    case ',': {
                        n2 = n4 - 1;
                        break block12;
                    }
                    default: {
                        if (n4 < n3) continue block12;
                        n2 = n4;
                        break block12;
                    }
                }
            }
        }
        return n2;
    }

    private String checkValue(String string) throws MalformedObjectNameException {
        if (string == null) {
            throw new MalformedObjectNameException("Invalid value (null)");
        }
        int n = string.length();
        if (n == 0) {
            throw new MalformedObjectNameException("Invalid value (empty)");
        }
        char[] cArray = string.toCharArray();
        int n2 = ObjectName.parseValue(cArray, 0);
        if (n2 < n) {
            throw new MalformedObjectNameException("Invalid character in value: `" + cArray[n2] + "'");
        }
        return string;
    }

    private String checkKey(String string) throws MalformedObjectNameException {
        if (string == null) {
            throw new MalformedObjectNameException("Invalid key (null)");
        }
        int n = string.length();
        if (n == 0) {
            throw new MalformedObjectNameException("Invalid key (empty)");
        }
        char[] cArray = string.toCharArray();
        int n2 = ObjectName.parseKey(cArray, 0);
        if (n2 < n) {
            throw new MalformedObjectNameException("Invalid character in value: `" + cArray[n2] + "'");
        }
        return string;
    }

    private static boolean wildmatch(char[] cArray, char[] cArray2, int n, int n2) {
        int n3 = cArray.length;
        int n4 = cArray2.length;
        while (n2 < n4) {
            char c;
            if ((c = cArray2[n2++]) == '?') {
                if (++n <= n3) continue;
                return false;
            }
            if (c == '*') {
                if (n2 >= n4) {
                    return true;
                }
                do {
                    if (!ObjectName.wildmatch(cArray, cArray2, n, n2)) continue;
                    return true;
                } while (++n < n3);
                return false;
            }
            if (n < n3 && c == cArray[n++]) continue;
            return false;
        }
        return n == n3;
    }

    private boolean isDomain(String string) {
        if (string == null) {
            return true;
        }
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2++];
            switch (c) {
                case '\n': 
                case ':': {
                    return false;
                }
                case '*': 
                case '?': {
                    this._domain_pattern = true;
                }
            }
        }
        return true;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        if (compat) {
            objectInputStream.defaultReadObject();
        } else {
            objectInputStream.defaultReadObject();
            String string = (String)objectInputStream.readObject();
            try {
                this.construct(string);
            }
            catch (MalformedObjectNameException malformedObjectNameException) {
                throw new InvalidObjectException(malformedObjectNameException.toString());
            }
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (compat) {
            ObjectOutputStream.PutField putField = objectOutputStream.putFields();
            putField.put("domain", this._canonicalName.substring(0, this._domain_length));
            putField.put("propertyList", this.getKeyPropertyList());
            putField.put("propertyListString", this.getKeyPropertyListString());
            putField.put("canonicalName", this._canonicalName);
            putField.put("pattern", this._domain_pattern || this._property_pattern);
            putField.put("propertyPattern", this._property_pattern);
            objectOutputStream.writeFields();
        } else {
            objectOutputStream.defaultWriteObject();
            objectOutputStream.writeObject(this.getSerializedNameString());
        }
    }

    public static ObjectName getInstance(String string) throws MalformedObjectNameException, NullPointerException {
        return new ObjectName(string);
    }

    public static ObjectName getInstance(String string, String string2, String string3) throws MalformedObjectNameException, NullPointerException {
        return new ObjectName(string, string2, string3);
    }

    public static ObjectName getInstance(String string, Hashtable hashtable) throws MalformedObjectNameException, NullPointerException {
        return new ObjectName(string, hashtable);
    }

    public static ObjectName getInstance(ObjectName objectName) throws NullPointerException {
        if (objectName.getClass().equals(class$javax$management$ObjectName == null ? (class$javax$management$ObjectName = ObjectName.class$("javax.management.ObjectName")) : class$javax$management$ObjectName)) {
            return objectName;
        }
        try {
            return new ObjectName(objectName.getCanonicalName());
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            throw new IllegalArgumentException("Unexpected: " + malformedObjectNameException);
        }
    }

    public ObjectName(String string) throws MalformedObjectNameException, NullPointerException {
        this.construct(string);
    }

    public ObjectName(String string, String string2, String string3) throws MalformedObjectNameException, NullPointerException {
        Hashtable<String, String> hashtable = new Hashtable<String, String>(1);
        if (string2 == null || string3 == null) {
            throw new MalformedObjectNameException("Neither the key nor the value can be null");
        }
        hashtable.put(string2, string3);
        this.construct(string, hashtable);
    }

    public ObjectName(String string, Hashtable hashtable) throws MalformedObjectNameException, NullPointerException {
        if (hashtable == null) {
            throw new MalformedObjectNameException("Hashtable is null");
        }
        if (hashtable.isEmpty()) {
            throw new MalformedObjectNameException("Empty Hashtable");
        }
        this.construct(string, hashtable);
    }

    public boolean isPattern() {
        return this._domain_pattern || this._property_pattern;
    }

    public boolean isDomainPattern() {
        return this._domain_pattern;
    }

    public boolean isPropertyPattern() {
        return this._property_pattern;
    }

    public String getCanonicalName() {
        return this._canonicalName;
    }

    public String getDomain() {
        return this._canonicalName.substring(0, this._domain_length);
    }

    public String getKeyProperty(String string) throws NullPointerException {
        return (String)this._getKeyPropertyList().get(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Hashtable _getKeyPropertyList() {
        ObjectName objectName = this;
        synchronized (objectName) {
            if (this._propertyList == null) {
                this._propertyList = new Hashtable();
                int n = this._ca_array.length;
                for (int i = n - 1; i >= 0; --i) {
                    Property property = this._ca_array[i];
                    this._propertyList.put(property.getKeyString(this._canonicalName), property.getValueString(this._canonicalName));
                }
            }
        }
        return this._propertyList;
    }

    public Hashtable getKeyPropertyList() {
        return (Hashtable)this._getKeyPropertyList().clone();
    }

    public String getKeyPropertyListString() {
        if (this._kp_array.length == 0) {
            return "";
        }
        int n = this._canonicalName.length() - this._domain_length - 1 - (this._property_pattern ? 2 : 0);
        char[] cArray = new char[n];
        char[] cArray2 = this._canonicalName.toCharArray();
        this.writeKeyPropertyListString(cArray2, cArray, 0);
        return new String(cArray);
    }

    private String getSerializedNameString() {
        int n = this._canonicalName.length();
        char[] cArray = new char[n];
        char[] cArray2 = this._canonicalName.toCharArray();
        int n2 = this._domain_length + 1;
        System.arraycopy(cArray2, 0, cArray, 0, n2);
        int n3 = this.writeKeyPropertyListString(cArray2, cArray, n2);
        if (this._property_pattern) {
            if (n3 == n2) {
                cArray[n3] = 42;
            } else {
                cArray[n3] = 44;
                cArray[n3 + 1] = 42;
            }
        }
        return new String(cArray);
    }

    private int writeKeyPropertyListString(char[] cArray, char[] cArray2, int n) {
        if (this._kp_array.length == 0) {
            return n;
        }
        char[] cArray3 = cArray2;
        char[] cArray4 = this._canonicalName.toCharArray();
        int n2 = n;
        int n3 = this._kp_array.length;
        int n4 = n3 - 1;
        for (int i = 0; i < n3; ++i) {
            Property property = this._kp_array[i];
            int n5 = property._lengths._key_length + property._lengths._value_length + 1;
            System.arraycopy(cArray4, property._key_index, cArray3, n2, n5);
            n2 += n5;
            if (i >= n4) continue;
            cArray3[n2++] = 44;
        }
        return n2;
    }

    public String getCanonicalKeyPropertyListString() {
        if (this._ca_array.length == 0) {
            return "";
        }
        int n = this._canonicalName.length();
        if (this._property_pattern) {
            n -= 2;
        }
        return this._canonicalName.substring(this._domain_length + 1, n);
    }

    public String toString() {
        return this.getSerializedNameString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ObjectName)) {
            return false;
        }
        ObjectName objectName = (ObjectName)object;
        String string = objectName._canonicalName;
        return this._canonicalName == string;
    }

    public int hashCode() {
        return this._canonicalName.hashCode();
    }

    public static String quote(String string) throws NullPointerException {
        StringBuffer stringBuffer = new StringBuffer("\"");
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\n': {
                    c = 'n';
                }
                case '\"': 
                case '*': 
                case '?': 
                case '\\': {
                    stringBuffer.append('\\');
                }
            }
            stringBuffer.append(c);
        }
        stringBuffer.append('\"');
        return stringBuffer.toString();
    }

    public static String unquote(String string) throws IllegalArgumentException, NullPointerException {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        if (n < 2 || string.charAt(0) != '\"' || string.charAt(n - 1) != '\"') {
            throw new IllegalArgumentException("Argument not quoted");
        }
        for (int i = 1; i < n - 1; ++i) {
            char c;
            block11: {
                block10: {
                    c = string.charAt(i);
                    if (c != '\\') break block10;
                    if (i == n - 2) {
                        throw new IllegalArgumentException("Trailing backslash");
                    }
                    c = string.charAt(++i);
                    switch (c) {
                        case 'n': {
                            c = '\n';
                            break block11;
                        }
                        case '\"': 
                        case '*': 
                        case '?': 
                        case '\\': {
                            break block11;
                        }
                        default: {
                            throw new IllegalArgumentException("Bad character '" + c + "' after backslash");
                        }
                    }
                }
                switch (c) {
                    case '\n': 
                    case '\"': 
                    case '*': 
                    case '?': {
                        throw new IllegalArgumentException("Invalid unescaped character '" + c + "' in the string to unquote");
                    }
                }
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public boolean apply(ObjectName objectName) throws NullPointerException {
        if (objectName == null) {
            throw new NullPointerException();
        }
        if (objectName._domain_pattern || objectName._property_pattern) {
            return false;
        }
        if (!this._domain_pattern && !this._property_pattern) {
            return this._canonicalName.equals(objectName._canonicalName);
        }
        return this.matchDomains(objectName) && this.matchKeys(objectName);
    }

    private final boolean matchDomains(ObjectName objectName) {
        if (this._domain_pattern) {
            char[] cArray = this.getDomain().toCharArray();
            char[] cArray2 = objectName.getDomain().toCharArray();
            return ObjectName.wildmatch(cArray2, cArray, 0, 0);
        }
        return this.getDomain().equals(objectName.getDomain());
    }

    private final boolean matchKeys(ObjectName objectName) {
        if (this._property_pattern) {
            Hashtable hashtable = objectName._getKeyPropertyList();
            Property[] propertyArray = this._ca_array;
            String string = this._canonicalName;
            for (int i = propertyArray.length - 1; i >= 0; --i) {
                Property property = propertyArray[i];
                String string2 = property.getKeyString(string);
                String string3 = (String)hashtable.get(string2);
                if (string3 == null) {
                    return false;
                }
                if (string3.equals(property.getValueString(string))) continue;
                return false;
            }
            return true;
        }
        String string = objectName.getCanonicalKeyPropertyListString();
        String string4 = this.getCanonicalKeyPropertyListString();
        return string.equals(string4);
    }

    public void setMBeanServer(MBeanServer mBeanServer) {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        compat = false;
        try {
            GetPropertyAction getPropertyAction = new GetPropertyAction("jmx.serial.form");
            String string = AccessController.doPrivileged(getPropertyAction);
            compat = string != null && string.equals("1.0");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (compat) {
            serialPersistentFields = oldSerialPersistentFields;
            serialVersionUID = -5467795090068647408L;
        } else {
            serialPersistentFields = newSerialPersistentFields;
            serialVersionUID = 1081892073854801359L;
        }
        _Empty_property_array = new Property[0];
        _EmptyPropertyList = new Hashtable(1);
    }

    private static final class Property {
        private static WeakHashMap _PropertyLengthCouples = new WeakHashMap(89);
        int _key_index;
        PropertyLengthCouple _lengths;

        Property(int n, PropertyLengthCouple propertyLengthCouple) {
            PropertyLengthCouple propertyLengthCouple2;
            this._key_index = n;
            WeakReference weakReference = (WeakReference)_PropertyLengthCouples.get(propertyLengthCouple);
            if (weakReference != null && (propertyLengthCouple2 = (PropertyLengthCouple)weakReference.get()) != null) {
                this._lengths = propertyLengthCouple2;
            } else {
                this._lengths = new PropertyLengthCouple(propertyLengthCouple._key_length, propertyLengthCouple._value_length);
                _PropertyLengthCouples.put(this._lengths, new WeakReference<PropertyLengthCouple>(this._lengths));
            }
        }

        void setKeyIndex(int n) {
            this._key_index = n;
        }

        String getKeyString(String string) {
            return string.substring(this._key_index, this._key_index + this._lengths._key_length);
        }

        String getValueString(String string) {
            int n = this._key_index + this._lengths._key_length + 1;
            int n2 = n + this._lengths._value_length;
            return string.substring(n, n2);
        }
    }

    private static final class PropertyLengthCouple {
        int _key_length = 0;
        int _value_length = 0;

        private PropertyLengthCouple(int n, int n2) {
            this._key_length = n;
            this._value_length = n2;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof PropertyLengthCouple)) {
                return false;
            }
            PropertyLengthCouple propertyLengthCouple = (PropertyLengthCouple)object;
            return this._key_length == propertyLengthCouple._key_length && this._value_length == propertyLengthCouple._value_length;
        }

        public int hashCode() {
            return this._key_length << 5 ^ this._value_length;
        }

        void setLengths(int n, int n2) {
            this._key_length = n;
            this._value_length = n2;
        }
    }
}

