/*
 * Decompiled with CFR 0.152.
 */
package com.lmax.disruptor;

import com.lmax.disruptor.util.Util;
import sun.misc.Unsafe;

public class Sequence {
    static final long INITIAL_VALUE = -1L;
    private static final Unsafe unsafe = Util.getUnsafe();
    private static final long valueOffset;
    private final long[] paddedValue = new long[15];

    public Sequence() {
        this(-1L);
    }

    public Sequence(long initialValue) {
        unsafe.putOrderedLong(this.paddedValue, valueOffset, initialValue);
    }

    public long get() {
        return unsafe.getLongVolatile(this.paddedValue, valueOffset);
    }

    public void set(long value) {
        unsafe.putOrderedLong(this.paddedValue, valueOffset, value);
    }

    public void setVolatile(long value) {
        unsafe.putLongVolatile(this.paddedValue, valueOffset, value);
    }

    public boolean compareAndSet(long expectedValue, long newValue) {
        return unsafe.compareAndSwapLong(this.paddedValue, valueOffset, expectedValue, newValue);
    }

    public long incrementAndGet() {
        return this.addAndGet(1L);
    }

    public long addAndGet(long increment) {
        long newValue;
        long currentValue;
        while (!this.compareAndSet(currentValue = this.get(), newValue = currentValue + increment)) {
        }
        return newValue;
    }

    public String toString() {
        return Long.toString(this.get());
    }

    static {
        int base = unsafe.arrayBaseOffset(long[].class);
        int scale = unsafe.arrayIndexScale(long[].class);
        valueOffset = base + scale * 7;
    }
}

