/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.blob;

import com.google.common.cache.Weigher;
import org.apache.jackrabbit.oak.cache.CacheLIRS;
import org.apache.jackrabbit.oak.spi.blob.AbstractBlobStore;

public abstract class CachingBlobStore
extends AbstractBlobStore {
    protected final CacheLIRS<String, byte[]> cache = CacheLIRS.newBuilder().maximumWeight(0x1000000L).averageWeight(this.getBlockSize() / 2).weigher(new Weigher<String, byte[]>(){

        public int weigh(String key, byte[] value) {
            return value.length;
        }
    }).build();

    public void clearCache() {
        this.cache.invalidateAll();
    }
}

