/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document;

import com.google.common.base.Preconditions;
import java.util.Comparator;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.plugins.document.Branch;
import org.apache.jackrabbit.oak.plugins.document.Collection;
import org.apache.jackrabbit.oak.plugins.document.DocumentStore;
import org.apache.jackrabbit.oak.plugins.document.NodeDocument;
import org.apache.jackrabbit.oak.plugins.document.Revision;
import org.apache.jackrabbit.oak.plugins.document.RevisionContext;
import org.apache.jackrabbit.oak.plugins.document.util.Utils;

class UnmergedBranches {
    private final List<Branch> branches = new CopyOnWriteArrayList<Branch>();
    private final AtomicBoolean initialized = new AtomicBoolean(false);
    private final Comparator<Revision> comparator;

    UnmergedBranches(@Nonnull Comparator<Revision> comparator) {
        this.comparator = (Comparator)Preconditions.checkNotNull(comparator);
    }

    void init(DocumentStore store, RevisionContext context) {
        if (!this.initialized.compareAndSet(false, true)) {
            throw new IllegalStateException("already initialized");
        }
        NodeDocument doc = store.find(Collection.NODES, Utils.getIdFromPath("/"));
        if (doc == null) {
            return;
        }
        SortedMap<Revision, Revision> revisions = doc.getUncommittedRevisions(context);
        while (!revisions.isEmpty()) {
            TreeSet<Revision> commits = new TreeSet<Revision>(this.comparator);
            Revision head = revisions.lastKey();
            commits.add(head);
            Revision base = ((Revision)revisions.remove(head)).asTrunkRevision();
            while (revisions.containsKey(base)) {
                commits.add(base);
                base = ((Revision)revisions.remove(base)).asTrunkRevision();
            }
            this.branches.add(new Branch(commits, base));
        }
    }

    @Nonnull
    Branch create(@Nonnull Revision base, @Nonnull Revision initial) {
        Preconditions.checkArgument((!((Revision)Preconditions.checkNotNull((Object)base)).isBranch() ? 1 : 0) != 0, (String)"base is not a trunk revision: %s", (Object[])new Object[]{base});
        Preconditions.checkArgument((boolean)((Revision)Preconditions.checkNotNull((Object)initial)).isBranch(), (String)"initial is not a branch revision: %s", (Object[])new Object[]{initial});
        TreeSet<Revision> commits = new TreeSet<Revision>(this.comparator);
        commits.add(initial);
        Branch b = new Branch(commits, base);
        this.branches.add(b);
        return b;
    }

    @CheckForNull
    Branch getBranch(@Nonnull Revision r) {
        for (Branch b : this.branches) {
            if (!b.containsCommit(r)) continue;
            return b;
        }
        return null;
    }

    void remove(Branch b) {
        this.branches.remove(b);
    }
}

