/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools.servicebuilder;

import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.TextFormatter;
import com.liferay.portal.tools.servicebuilder.Entity;
import com.liferay.portal.tools.servicebuilder.EntityColumn;
import java.util.List;

public class EntityFinder {
    private List<EntityColumn> _columns;
    private boolean _dbIndex;
    private String _name;
    private String _returnType;
    private boolean _unique;
    private String _where;

    public EntityFinder(String name, String returnType, boolean unique, String where, boolean dbIndex, List<EntityColumn> columns) {
        this._name = name;
        this._returnType = returnType;
        this._unique = unique;
        this._where = where;
        this._dbIndex = dbIndex;
        this._columns = columns;
        if (this.isCollection() && this.isUnique() && !this.hasArrayableOperator()) {
            throw new IllegalArgumentException("A finder cannot return a Collection and be unique unless it has an arrayable column. See the ExpandoColumn service.xml declaration for an example.");
        }
        if ((!this.isCollection() || this.isUnique()) && this.hasCustomComparator()) {
            throw new IllegalArgumentException("A unique finder cannot have a custom comparator");
        }
    }

    public EntityColumn getColumn(String name) {
        for (EntityColumn column : this._columns) {
            if (!name.equals(column.getName())) continue;
            return column;
        }
        return null;
    }

    public List<EntityColumn> getColumns() {
        return this._columns;
    }

    public String getHumanConditions(boolean arrayable) {
        if (this._columns.size() == 1) {
            return this._columns.get(0).getHumanCondition(arrayable);
        }
        StringBundler sb = new StringBundler(this._columns.size() * 2);
        for (EntityColumn column : this._columns) {
            sb.append(column.getHumanCondition(arrayable));
            sb.append(" and ");
        }
        if (!this._columns.isEmpty()) {
            sb.setIndex(sb.index() - 1);
        }
        return sb.toString();
    }

    public String getName() {
        return this._name;
    }

    public String getNames() {
        return TextFormatter.formatPlural((String)this._name);
    }

    public String getReturnType() {
        return this._returnType;
    }

    public String getWhere() {
        return this._where;
    }

    public boolean hasArrayableOperator() {
        for (EntityColumn column : this._columns) {
            if (!column.hasArrayableOperator()) continue;
            return true;
        }
        return false;
    }

    public boolean hasColumn(String name) {
        return Entity.hasColumn(name, this._columns);
    }

    public boolean hasCustomComparator() {
        for (EntityColumn column : this._columns) {
            String comparator = column.getComparator();
            if (comparator.equals("=")) continue;
            return true;
        }
        return false;
    }

    public boolean isCollection() {
        return this._returnType != null && this._returnType.equals("Collection");
    }

    public boolean isDBIndex() {
        return this._dbIndex;
    }

    public boolean isUnique() {
        return this._unique;
    }
}

