/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.sigar.win32.test;

import java.util.Iterator;
import java.util.Map;
import org.hyperic.sigar.test.SigarTestCase;
import org.hyperic.sigar.win32.Pdh;

public class TestPdh
extends SigarTestCase {
    public TestPdh(String name) {
        super(name);
    }

    private static boolean isCounter(long type) {
        return (type & 0x400L) == 1024L;
    }

    private void getValue(String key) throws Exception {
        Pdh pdh = new Pdh();
        this.traceln(key + ": " + pdh.getDescription(key));
        this.traceln("counter=" + TestPdh.isCounter(pdh.getCounterType(key)));
        this.assertGtEqZeroTrace("raw", (long)pdh.getRawValue(key));
        this.assertGtEqZeroTrace("fmt", (long)pdh.getFormattedValue(key));
    }

    public void testGetValue() throws Exception {
        Pdh.enableTranslation();
        String DL = "\\";
        String[][] keys = new String[][]{{"System", "System Up Time"}, {"Memory", "Available Bytes"}, {"Memory", "Pages/sec"}, {"Processor(_Total)", "% User Time"}};
        for (int i = 0; i < keys.length; ++i) {
            String path = "\\" + keys[i][0] + "\\" + keys[i][1];
            String trans = Pdh.translate(path);
            if (!trans.equals(path)) {
                this.traceln(path + "-->" + trans);
            }
            this.traceln(path + " validate: " + Pdh.validate(path));
            this.getValue(path);
        }
    }

    public void testCounterMap() throws Exception {
        Map counters = Pdh.getEnglishPerflibCounterMap();
        this.assertGtZeroTrace("counters", counters.size());
        int dups = 0;
        Iterator it = counters.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String name = (String)entry.getKey();
            int[] ix = (int[])entry.getValue();
            if (ix.length <= 1) continue;
            ++dups;
        }
        this.traceln(dups + " names have dups");
        String[] keys = new String[]{"System", "System Up Time"};
        int last = -1;
        for (int i = 0; i < keys.length; ++i) {
            String name = keys[i];
            int[] ix = (int[])counters.get(name.toLowerCase());
            TestPdh.assertFalse((ix[0] == last ? 1 : 0) != 0);
            this.traceln(name + "=" + ix[0]);
            last = ix[0];
            String lookupName = Pdh.getCounterName(ix[0]);
            this.traceln(name + "=" + lookupName);
        }
    }

    public void testValidate() {
        Object[][] tests = new Object[][]{{"\\Does Not\\Exist", new Integer(-1073738824), new Integer(-1073738816)}, {"Does Not Exist", new Integer(-1073738816)}, {"\\System\\DoesNotExist", new Integer(-1073738823)}, {"\\Processor(666)\\% User Time", new Integer(-2147481647)}, {"\\System\\Threads", new Integer(0), new Integer(-1073738816)}};
        for (int i = 0; i < tests.length; ++i) {
            boolean expectedResult;
            String path = (String)tests[i][0];
            int expect = (Integer)tests[i][1];
            int status = Pdh.validate(path);
            boolean bl = expectedResult = status == expect;
            if (!expectedResult && tests[i].length == 3) {
                expect = (Integer)tests[i][2];
                boolean bl2 = expectedResult = status == expect;
            }
            if (!expectedResult) {
                this.traceln("[validate] " + path + "-->" + Integer.toHexString(status).toUpperCase() + " != " + Integer.toHexString(expect).toUpperCase());
            }
            TestPdh.assertTrue((boolean)expectedResult);
        }
    }

    public void testPdh() throws Exception {
        String[] iface = Pdh.getKeys("Thread");
        TestPdh.assertTrue((iface.length > 0 ? 1 : 0) != 0);
    }
}

