/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.dynamic;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.persistence.dynamic.DynamicClassWriter;
import org.eclipse.persistence.exceptions.DynamicException;
import org.eclipse.persistence.internal.helper.ConversionManager;
import org.eclipse.persistence.sessions.Session;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DynamicClassLoader
extends ClassLoader {
    protected Map<String, DynamicClassWriter> classWriters = new HashMap<String, DynamicClassWriter>();
    public DynamicClassWriter defaultWriter = new DynamicClassWriter();

    public DynamicClassLoader(ClassLoader delegate) {
        super(delegate);
    }

    public DynamicClassLoader(ClassLoader delegate, DynamicClassWriter writer) {
        this(delegate);
        this.defaultWriter = writer;
    }

    public DynamicClassWriter getDefaultWriter() {
        return this.defaultWriter;
    }

    protected Map<String, DynamicClassWriter> getClassWriters() {
        return this.classWriters;
    }

    public DynamicClassWriter getClassWriter(String className) {
        return this.getClassWriters().get(className);
    }

    public void addClass(String className) {
        this.addClass(className, this.getDefaultWriter());
    }

    public void addClass(String className, Class<?> parentClass) {
        this.addClass(className, this.getDefaultWriter().createCopy(parentClass));
    }

    public void addClass(String className, DynamicClassWriter writer) throws DynamicException {
        DynamicClassWriter existingWriter = this.getClassWriter(className);
        if (existingWriter != null) {
            if (!existingWriter.isCompatible(writer)) {
                throw DynamicException.incompatibleDuplicateWriters(className, existingWriter, writer);
            }
        } else {
            this.getClassWriters().put(className, writer == null ? this.getDefaultWriter() : writer);
        }
    }

    public Class<?> createDynamicClass(String className, DynamicClassWriter writer) throws DynamicException {
        this.addClass(className, writer);
        try {
            return this.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("DyanmicClassLoader could not create class: " + className);
        }
    }

    public Class<?> createDynamicClass(String className) {
        return this.createDynamicClass(className, this.getDefaultWriter());
    }

    public Class<?> createDynamicClass(String className, Class<?> parentClass) {
        return this.createDynamicClass(className, new DynamicClassWriter(parentClass));
    }

    @Override
    protected Class<?> findClass(String className) throws ClassNotFoundException {
        DynamicClassWriter writer = this.getClassWriter(className);
        if (writer != null) {
            try {
                byte[] bytes = writer.writeClass(this, className);
                return this.defineClass(className, bytes, 0, bytes.length);
            }
            catch (ClassFormatError cfe) {
                throw new ClassNotFoundException(className, cfe);
            }
        }
        return super.findClass(className);
    }

    public static DynamicClassLoader lookup(Session session) {
        ConversionManager cm = null;
        cm = session == null ? ConversionManager.getDefaultManager() : session.getPlatform().getConversionManager();
        if (cm.getLoader() instanceof DynamicClassLoader) {
            return (DynamicClassLoader)cm.getLoader();
        }
        DynamicClassLoader dcl = new DynamicClassLoader(cm.getLoader());
        cm.setLoader(dcl);
        if (session == null) {
            ConversionManager.setDefaultLoader(dcl);
        }
        return dcl;
    }
}

