/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.grs.reader;

import gr.uoa.di.madgik.grs.buffer.IBuffer;
import gr.uoa.di.madgik.grs.reader.ForwardReader;
import gr.uoa.di.madgik.grs.reader.GRS2ReaderException;
import gr.uoa.di.madgik.grs.record.GRS2ExceptionWrapper;
import gr.uoa.di.madgik.grs.record.Record;
import gr.uoa.di.madgik.grs.record.exception.GRS2UncheckedException;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class ForwardReaderIterator<T extends Record>
implements Iterator<T> {
    private ForwardReader<T> reader = null;
    private boolean timeoutExpired = false;

    protected ForwardReaderIterator(ForwardReader<T> reader) {
        this.reader = reader;
    }

    @Override
    public boolean hasNext() {
        try {
            if (this.reader.getStatus() == IBuffer.Status.Dispose || this.reader.getStatus() == IBuffer.Status.Close && this.reader.availableRecords() == 0) {
                return false;
            }
            if (this.reader.availableRecords() == 0) {
                if (this.timeoutExpired) {
                    return false;
                }
                boolean bl = this.timeoutExpired = !this.reader.waitAvailable(this.reader.getIteratorTimeout(), this.reader.getIteratorTimeUnit());
                if (this.timeoutExpired) {
                    this.reader.close();
                }
            }
            return !this.timeoutExpired;
        }
        catch (GRS2ReaderException e) {
            return false;
        }
    }

    @Override
    public T next() {
        try {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            T rec = this.reader.get(this.reader.getIteratorTimeout(), this.reader.getIteratorTimeUnit());
            if (rec instanceof GRS2ExceptionWrapper) {
                GRS2UncheckedException ex = new GRS2UncheckedException("writer error", ((GRS2ExceptionWrapper)rec).getEx());
                throw ex;
            }
            return rec;
        }
        catch (GRS2ReaderException e) {
            throw new GRS2UncheckedException("error reading the records from iterator", e);
        }
    }

    @Override
    public void remove() {
        throw new IllegalStateException("Operation not supported");
    }
}

