/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.grs.registry;

import gr.uoa.di.madgik.grs.buffer.IBuffer;
import gr.uoa.di.madgik.grs.registry.LifecycleManager;
import gr.uoa.di.madgik.grs.store.buffer.IBufferStore;
import java.util.Collection;
import java.util.Hashtable;
import java.util.UUID;

public class GRSRegistry {
    public static final GRSRegistry Registry = new GRSRegistry();
    private Hashtable<String, IBuffer> mapBuffer = new Hashtable();
    private Hashtable<String, IBufferStore> mapStore = new Hashtable();
    private static final LifecycleManager lifecycle = new LifecycleManager();

    private GRSRegistry() {
    }

    public synchronized String add(IBuffer buffer) {
        String key = null;
        key = UUID.randomUUID().toString();
        this.mapBuffer.put(key, buffer);
        return key;
    }

    public synchronized String add(IBufferStore store) {
        String key = null;
        key = UUID.randomUUID().toString();
        this.mapStore.put(key, store);
        return key;
    }

    public synchronized IBuffer getBuffer(String key) {
        if (key == null) {
            return null;
        }
        if (!this.mapBuffer.containsKey(key)) {
            return null;
        }
        return this.mapBuffer.get(key);
    }

    public synchronized IBufferStore getStore(String key) {
        if (key == null) {
            return null;
        }
        if (!this.mapStore.containsKey(key)) {
            return null;
        }
        return this.mapStore.get(key);
    }

    public synchronized void remove(String key) {
        IBufferStore store;
        if (key == null) {
            return;
        }
        if (this.mapBuffer.containsKey(key)) {
            IBuffer buf = this.mapBuffer.remove(key);
            if (buf != null) {
                try {
                    buf.dispose();
                }
                catch (Exception exception) {}
            }
        } else if (this.mapStore.containsKey(key) && (store = this.mapStore.remove(key)) != null) {
            try {
                store.dispose();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected synchronized Collection<IBuffer> getBufferEntries() {
        return this.mapBuffer.values();
    }

    protected synchronized Collection<IBufferStore> getStoreEntries() {
        return this.mapStore.values();
    }

    static {
        lifecycle.setName("lifecycle manager");
        lifecycle.setDaemon(true);
        lifecycle.start();
    }
}

