/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.blobstorage.service.impl;

import org.bson.types.ObjectId;
import org.gcube.contentmanagement.blobstorage.resource.MyFile;
import org.gcube.contentmanagement.blobstorage.service.directoryOperation.BucketCoding;
import org.gcube.contentmanagement.blobstorage.service.impl.ServiceEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Resource {
    final Logger logger = LoggerFactory.getLogger(ServiceEngine.class);
    protected MyFile file;
    protected ServiceEngine engine;

    public Resource(MyFile file, ServiceEngine engine) {
        this.setMyFile(file);
        this.setEngine(engine);
    }

    protected ServiceEngine getEngine() {
        return this.engine;
    }

    protected void setEngine(ServiceEngine engine) {
        this.engine = engine;
    }

    protected MyFile getMyFile() {
        return this.file;
    }

    protected void setMyFile(MyFile f) {
        this.file = f;
    }

    protected MyFile setGenericProperties(String context, String owner, String path, String type) {
        if (path != null && path.length() > 0) {
            if (ObjectId.isValid((String)path)) {
                this.file.setId(path);
            } else if (type.equalsIgnoreCase("remote") && context != null && context.length() > 0) {
                this.file.setRootPath(context);
                path = new BucketCoding().bucketFileCoding(path, context);
                this.file.setAbsoluteRemotePath(path);
            }
            String[] dirs = path.split("/");
            String name = dirs[dirs.length - 1];
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("path(String) - name: " + name);
            }
            if (this.file == null) {
                this.file = new MyFile(name, this.engine.getGcubeMemoryType());
            } else {
                this.file.setName(name);
            }
            this.file.setOwner(owner);
            String dir = path.substring(0, path.length() - name.length());
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("path(String) - path: " + dir);
            }
            if (type.equalsIgnoreCase("local")) {
                if (this.file.getLocalDir() == null) {
                    this.file.setLocalDir(dir);
                }
            } else if (this.file.getRemoteDir() == null) {
                this.file.setRemoteDir(dir);
            }
        } else {
            this.file.setOwner(owner);
        }
        return this.file;
    }

    protected Object getRemoteObject(MyFile file, String[] backend, String[] vltBackend) {
        Object obj = null;
        obj = this.retrieveRemoteObject(file, backend);
        if (obj == null && vltBackend != null && vltBackend.length > 0) {
            obj = this.retrieveRemoteObject(file, vltBackend);
        }
        return obj;
    }

    protected Object retrieveRemoteObject(MyFile file, String[] backend) {
        Object obj = null;
        try {
            if (file.getInputStream() != null || file.getOutputStream() != null || file.getLocalPath() != null || file.getRemotePath() != null) {
                obj = this.engine.service.startOperation(file, file.getRemotePath(), file.getOwner(), backend, false, file.getRootPath(), file.isReplace());
            } else {
                this.logger.error("parameters incompatible ");
            }
        }
        catch (Exception e) {
            this.logger.error("get()", (Throwable)e);
        }
        return obj;
    }
}

