/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.value;

import com.google.common.base.Objects;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.CheckForNull;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.api.ReferenceBinary;
import org.apache.jackrabbit.oak.plugins.value.ValueImpl;

class BinaryImpl
implements ReferenceBinary {
    private final ValueImpl value;

    BinaryImpl(ValueImpl value) {
        this.value = value;
    }

    ValueImpl getBinaryValue() {
        return this.value.getType() == 2 ? this.value : null;
    }

    public InputStream getStream() {
        return this.value.getBlob().getNewStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(byte[] b, long position) throws IOException {
        InputStream stream = this.getStream();
        try {
            if (position != stream.skip(position)) {
                throw new IOException("Can't skip to position " + position);
            }
            int n = stream.read(b);
            return n;
        }
        finally {
            stream.close();
        }
    }

    public long getSize() throws RepositoryException {
        switch (this.value.getType()) {
            case 7: 
            case 8: {
                return this.value.getString().length();
            }
        }
        return this.value.getBlob().length();
    }

    public void dispose() {
    }

    @CheckForNull
    public String getReference() {
        return this.value.getBlob().getReference();
    }

    public boolean equals(Object other) {
        if (other instanceof ReferenceBinary) {
            return Objects.equal((Object)this.getReference(), (Object)((ReferenceBinary)other).getReference());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getReference()});
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).addValue((Object)this.value).toString();
    }
}

