/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.authentication.user;

import java.io.IOException;
import java.security.Principal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.jcr.Credentials;
import javax.jcr.GuestCredentials;
import javax.jcr.SimpleCredentials;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import org.apache.jackrabbit.oak.api.AuthInfo;
import org.apache.jackrabbit.oak.security.authentication.user.UserAuthentication;
import org.apache.jackrabbit.oak.spi.security.ConfigurationParameters;
import org.apache.jackrabbit.oak.spi.security.SecurityProvider;
import org.apache.jackrabbit.oak.spi.security.authentication.AbstractLoginModule;
import org.apache.jackrabbit.oak.spi.security.authentication.AuthInfoImpl;
import org.apache.jackrabbit.oak.spi.security.authentication.ImpersonationCredentials;
import org.apache.jackrabbit.oak.spi.security.authentication.PreAuthenticatedLogin;
import org.apache.jackrabbit.oak.spi.security.user.UserConfiguration;
import org.apache.jackrabbit.oak.spi.security.user.util.UserUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LoginModuleImpl
extends AbstractLoginModule {
    private static final Logger log = LoggerFactory.getLogger(LoginModuleImpl.class);
    protected static final Set<Class> SUPPORTED_CREDENTIALS = new HashSet<Class>(3);
    private Credentials credentials;
    private Set<? extends Principal> principals;
    private String userId;

    @Override
    public boolean login() throws LoginException {
        boolean success;
        this.credentials = this.getCredentials();
        PreAuthenticatedLogin preAuthLogin = this.getSharedPreAuthLogin();
        if (preAuthLogin != null) {
            this.userId = preAuthLogin.getUserId();
            UserAuthentication authentication = new UserAuthentication(this.userId, this.getUserManager());
            success = authentication.authenticate(UserAuthentication.PRE_AUTHENTICATED);
        } else {
            this.userId = this.getUserId();
            UserAuthentication authentication = new UserAuthentication(this.userId, this.getUserManager());
            success = authentication.authenticate(this.credentials);
        }
        if (success) {
            this.principals = this.getPrincipals(this.userId);
            log.debug("Adding Credentials to shared state.");
            this.sharedState.put("org.apache.jackrabbit.credentials", this.credentials);
            log.debug("Adding login name to shared state.");
            this.sharedState.put("javax.security.auth.login.name", this.userId);
        }
        return success;
    }

    @Override
    public boolean commit() {
        if (this.credentials == null || this.principals == null) {
            this.clearState();
            return false;
        }
        if (!this.subject.isReadOnly()) {
            this.subject.getPrincipals().addAll(this.principals);
            this.subject.getPublicCredentials().add(this.credentials);
            LoginModuleImpl.setAuthInfo(this.createAuthInfo(), this.subject);
        } else {
            log.debug("Could not add information to read only subject {}", (Object)this.subject);
        }
        return true;
    }

    @Override
    protected Set<Class> getSupportedCredentials() {
        return SUPPORTED_CREDENTIALS;
    }

    @Override
    protected void clearState() {
        super.clearState();
        this.credentials = null;
        this.principals = null;
        this.userId = null;
    }

    @CheckForNull
    private String getUserId() {
        String uid = null;
        if (this.credentials != null) {
            if (this.credentials instanceof SimpleCredentials) {
                uid = ((SimpleCredentials)this.credentials).getUserID();
            } else if (this.credentials instanceof GuestCredentials) {
                uid = this.getAnonymousId();
            } else if (this.credentials instanceof ImpersonationCredentials) {
                Credentials bc = ((ImpersonationCredentials)this.credentials).getBaseCredentials();
                if (bc instanceof SimpleCredentials) {
                    uid = ((SimpleCredentials)bc).getUserID();
                }
            } else {
                try {
                    NameCallback callback = new NameCallback("User-ID: ");
                    this.callbackHandler.handle(new Callback[]{callback});
                    uid = callback.getName();
                }
                catch (UnsupportedCallbackException e) {
                    log.warn("Credentials- or NameCallback must be supported");
                }
                catch (IOException e) {
                    log.error("Name-Callback failed: " + e.getMessage());
                }
            }
        }
        if (uid == null) {
            uid = this.getSharedLoginName();
        }
        return uid;
    }

    private String getAnonymousId() {
        SecurityProvider sp = this.getSecurityProvider();
        if (sp == null) {
            return null;
        }
        ConfigurationParameters params = sp.getConfiguration(UserConfiguration.class).getParameters();
        return UserUtil.getAnonymousId(params);
    }

    private AuthInfo createAuthInfo() {
        HashMap<String, Object> attributes;
        block3: {
            Credentials creds;
            block2: {
                creds = this.credentials instanceof ImpersonationCredentials ? ((ImpersonationCredentials)this.credentials).getBaseCredentials() : this.credentials;
                attributes = new HashMap<String, Object>();
                Object shared = this.sharedState.get("javax.security.auth.login.attributes");
                if (!(shared instanceof Map)) break block2;
                for (Object key : ((Map)shared).keySet()) {
                    attributes.put(key.toString(), ((Map)shared).get(key));
                }
                break block3;
            }
            if (!(creds instanceof SimpleCredentials)) break block3;
            SimpleCredentials sc = (SimpleCredentials)creds;
            for (String attrName : sc.getAttributeNames()) {
                attributes.put(attrName, sc.getAttribute(attrName));
            }
        }
        return new AuthInfoImpl(this.userId, attributes, this.principals);
    }

    static {
        SUPPORTED_CREDENTIALS.add(SimpleCredentials.class);
        SUPPORTED_CREDENTIALS.add(GuestCredentials.class);
        SUPPORTED_CREDENTIALS.add(ImpersonationCredentials.class);
    }
}

