/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.authorization.permission;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.core.ImmutableRoot;
import org.apache.jackrabbit.oak.plugins.tree.ImmutableTree;
import org.apache.jackrabbit.oak.security.authorization.permission.PermissionUtil;
import org.apache.jackrabbit.oak.security.authorization.permission.PermissionValidator;
import org.apache.jackrabbit.oak.security.authorization.permission.PermissionValidatorProvider;
import org.apache.jackrabbit.oak.spi.commit.EditorDiff;
import org.apache.jackrabbit.oak.spi.commit.MoveTracker;
import org.apache.jackrabbit.oak.spi.commit.Validator;
import org.apache.jackrabbit.oak.spi.commit.VisibleValidator;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.PermissionProvider;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.TreePermission;
import org.apache.jackrabbit.oak.spi.state.NodeState;

public class MoveAwarePermissionValidator
extends PermissionValidator {
    private final MoveContext moveCtx;

    MoveAwarePermissionValidator(@Nonnull ImmutableTree rootBefore, @Nonnull ImmutableTree rootAfter, @Nonnull PermissionProvider permissionProvider, @Nonnull PermissionValidatorProvider provider, @Nonnull MoveTracker moveTracker) {
        super(rootBefore, rootAfter, permissionProvider, provider);
        this.moveCtx = new MoveContext(moveTracker, rootBefore, rootAfter);
    }

    MoveAwarePermissionValidator(@Nullable ImmutableTree parentBefore, @Nullable ImmutableTree parentAfter, @Nonnull TreePermission parentPermission, @Nonnull PermissionValidator parentValidator) {
        super(parentBefore, parentAfter, parentPermission, parentValidator);
        MoveAwarePermissionValidator pv = (MoveAwarePermissionValidator)parentValidator;
        this.moveCtx = pv.moveCtx;
    }

    @Override
    PermissionValidator createValidator(@Nullable ImmutableTree parentBefore, @Nullable ImmutableTree parentAfter, @Nonnull TreePermission parentPermission, @Nonnull PermissionValidator parentValidator) {
        if (this.moveCtx.containsMove(parentBefore, parentAfter)) {
            return new MoveAwarePermissionValidator(parentBefore, parentAfter, parentPermission, parentValidator);
        }
        return super.createValidator(parentBefore, parentAfter, parentPermission, parentValidator);
    }

    private Validator visibleValidator(@Nonnull ImmutableTree source, @Nonnull ImmutableTree dest) {
        ImmutableTree parent = this.moveCtx.rootBefore.getTree("/");
        TreePermission tp = this.getPermissionProvider().getTreePermission(parent, TreePermission.EMPTY);
        for (String n : PathUtils.elements((String)source.getPath())) {
            tp = tp.getChildPermission(n, parent.getChild(n).getNodeState());
        }
        PermissionValidator validator = this.createValidator(source, dest, tp, this);
        return new VisibleValidator(validator, true, false);
    }

    @Override
    public Validator childNodeAdded(String name, NodeState after) throws CommitFailedException {
        if (this.moveCtx.processAdd((ImmutableTree)this.getParentAfter().getChild(name), this)) {
            return null;
        }
        return super.childNodeAdded(name, after);
    }

    @Override
    public Validator childNodeDeleted(String name, NodeState before) throws CommitFailedException {
        if (this.moveCtx.processDelete((ImmutableTree)this.getParentBefore().getChild(name), this)) {
            return null;
        }
        return super.childNodeDeleted(name, before);
    }

    private final class MoveContext {
        private final MoveTracker moveTracker;
        private final ImmutableRoot rootBefore;
        private final ImmutableRoot rootAfter;

        private MoveContext(@Nonnull MoveTracker moveTracker, @Nonnull ImmutableTree before, ImmutableTree after) {
            this.moveTracker = moveTracker;
            this.rootBefore = new ImmutableRoot(before);
            this.rootAfter = new ImmutableRoot(after);
        }

        private boolean containsMove(Tree parentBefore, Tree parentAfter) {
            return this.moveTracker.containsMove(PermissionUtil.getPath(parentBefore, parentAfter));
        }

        private boolean processAdd(ImmutableTree child, MoveAwarePermissionValidator validator) throws CommitFailedException {
            ImmutableTree source;
            String sourcePath = this.moveTracker.getSourcePath(child.getPath());
            if (sourcePath != null && (source = this.rootBefore.getTree(sourcePath)).exists()) {
                validator.checkPermissions(child, false, 544L);
                this.checkPermissions(source, 64L);
                return this.diff(source, child, validator);
            }
            return false;
        }

        private boolean processDelete(ImmutableTree child, MoveAwarePermissionValidator validator) throws CommitFailedException {
            ImmutableTree dest;
            String destPath = this.moveTracker.getDestPath(child.getPath());
            if (destPath != null && (dest = this.rootAfter.getTree(destPath)).exists()) {
                validator.checkPermissions(child, true, 64L);
                this.checkPermissions(dest, 544L);
                return this.diff(child, dest, validator);
            }
            return false;
        }

        private boolean diff(ImmutableTree source, ImmutableTree dest, MoveAwarePermissionValidator validator) throws CommitFailedException {
            Validator nextValidator = validator.visibleValidator(source, dest);
            CommitFailedException e = EditorDiff.process(nextValidator, source.getNodeState(), dest.getNodeState());
            if (e != null) {
                throw e;
            }
            return true;
        }

        private void checkPermissions(@Nonnull Tree tree, long permissions) throws CommitFailedException {
            if (!MoveAwarePermissionValidator.this.getPermissionProvider().isGranted(tree, null, permissions)) {
                throw new CommitFailedException("Access", 0, "Access denied");
            }
        }
    }
}

