/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.authorization.permission;

import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.plugins.tree.ImmutableTree;
import org.apache.jackrabbit.oak.plugins.version.VersionConstants;
import org.apache.jackrabbit.oak.spi.security.Context;
import org.apache.jackrabbit.oak.spi.state.NodeStateUtils;

public final class TreeTypeProvider {
    public static final int TYPE_DEFAULT = 1;
    public static final int TYPE_VERSION = 2;
    public static final int TYPE_INTERNAL = 4;
    public static final int TYPE_AC = 8;
    public static final int TYPE_HIDDEN = 16;
    private final Context contextInfo;

    public TreeTypeProvider(@Nonnull Context contextInfo) {
        this.contextInfo = contextInfo;
    }

    public int getType(ImmutableTree tree) {
        if (tree.isRoot()) {
            return 1;
        }
        return this.getType(tree, this.getType(tree.getParent()));
    }

    public int getType(ImmutableTree tree, int parentType) {
        int type;
        if (tree.isRoot()) {
            return 1;
        }
        switch (parentType) {
            case 16: {
                type = 16;
                break;
            }
            case 2: {
                type = 2;
                break;
            }
            case 4: {
                type = 4;
                break;
            }
            case 8: {
                type = 8;
                break;
            }
            default: {
                String name = tree.getName();
                type = NodeStateUtils.isHidden(name) ? 16 : (VersionConstants.VERSION_STORE_ROOT_NAMES.contains(name) ? 2 : ("rep:permissionStore".equals(name) ? 4 : (this.contextInfo.definesContextRoot(tree) ? 8 : 1)));
            }
        }
        return type;
    }
}

