/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.homelibrary.jcr.workspace.accessmanager;

import com.thoughtworks.xstream.XStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.RepositoryException;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.gcube.common.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.common.homelibrary.home.workspace.accessmanager.ACLType;
import org.gcube.common.homelibrary.home.workspace.accessmanager.AccessManager;
import org.gcube.common.homelibrary.jcr.repository.JCRRepository;
import org.gcube.common.homelibrary.jcr.workspace.util.TokenUtility;
import org.gcube.common.homelibrary.util.WorkspaceUtil;
import org.gcube.common.resources.gcore.GCoreEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JCRAccessManager
implements AccessManager {
    private Logger logger = LoggerFactory.getLogger(JCRAccessManager.class);
    Map<String, GCoreEndpoint.Profile.Endpoint> servlets = JCRRepository.servlets;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ACLType getACLByUser(String user, String absPath) {
        this.logger.debug("Get ACL for resource " + absPath + " for user: " + user);
        GetMethod getMethod = null;
        ACLType aclType = null;
        ArrayList<String> list = new ArrayList<String>();
        try {
            HttpClient httpClient = new HttpClient();
            String requestUrl = this.servlets.get("GetACLByUser").uri().toString() + "?login=" + user + "&absPath=" + URLEncoder.encode(absPath, "UTF-8");
            getMethod = new GetMethod(requestUrl);
            TokenUtility.setHeader(getMethod);
            httpClient.executeMethod((HttpMethod)getMethod);
            this.logger.debug("Response " + getMethod.getResponseBodyAsString());
            if (getMethod != null) {
                getMethod.releaseConnection();
            }
            XStream xstream = new XStream();
            String acl = (String)xstream.fromXML(getMethod.getResponseBodyAsString());
            list.add(acl);
            aclType = WorkspaceUtil.getACLTypeByKey(list);
        }
        catch (Exception e) {
            this.logger.error("Error deleting Permissions in AccessManager", (Throwable)e);
        }
        finally {
            if (getMethod != null) {
                getMethod.releaseConnection();
            }
        }
        return aclType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, List<String>> getACL(String absPath) throws InternalErrorException {
        this.logger.debug("Get ACL for resource " + absPath);
        Map map = null;
        GetMethod getMethod = null;
        try {
            HttpClient httpClient = new HttpClient();
            String requestUrl = this.servlets.get("GetACL").uri().toString() + "?absPath=" + URLEncoder.encode(absPath, "UTF-8");
            getMethod = new GetMethod(requestUrl);
            TokenUtility.setHeader(getMethod);
            httpClient.executeMethod((HttpMethod)getMethod);
            this.logger.debug("Response " + getMethod.getResponseBodyAsString());
            XStream xstream = new XStream();
            map = (Map)xstream.fromXML(getMethod.getResponseBodyAsString());
        }
        catch (Exception e) {
            this.logger.error("Error reatriving ACL", (Throwable)e);
        }
        finally {
            if (getMethod != null) {
                getMethod.releaseConnection();
            }
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean modifyAce(List<String> users, String absPath, List<String> privilegesList, String order) throws InternalErrorException {
        Boolean modified;
        block17: {
            this.logger.debug("Modify ACL on resource " + absPath + " for users: " + users.toString());
            modified = true;
            try {
                Map<String, List<String>> map = this.getACL(absPath);
                if (map.containsKey(users.get(0))) {
                    this.deleteAces(absPath, users);
                }
            }
            catch (Exception e) {
                this.logger.error("Error deleting old ACLs: " + e);
                throw new InternalErrorException((Throwable)e);
            }
            GetMethod getMethod = null;
            try {
                HttpClient httpClient = new HttpClient();
                StringBuilder privileges = new StringBuilder();
                for (String privilege : privilegesList) {
                    privileges.append("&privilege@" + privilege);
                }
                if (order == null) {
                    order = "first";
                }
                for (String user : users) {
                    try {
                        String requestUrl = this.servlets.get("ModifyAceServlet").uri().toString() + "?principalId=" + user + "&resourcePath=" + URLEncoder.encode(absPath, "UTF-8") + privileges.toString() + "&order=" + order;
                        getMethod = new GetMethod(requestUrl);
                        TokenUtility.setHeader(getMethod);
                        httpClient.executeMethod((HttpMethod)getMethod);
                        this.logger.debug("Response " + getMethod.getResponseBodyAsString());
                        if (getMethod == null) continue;
                        getMethod.releaseConnection();
                    }
                    catch (Exception e) {
                        this.logger.error("Error modifing ACLs: " + e);
                        throw new InternalErrorException((Throwable)e);
                    }
                }
                XStream xstream = new XStream();
                try {
                    if (getMethod.getResponseBodyAsString() == null) {
                        modified = false;
                        break block17;
                    }
                    modified = (Boolean)xstream.fromXML(getMethod.getResponseBodyAsString());
                }
                catch (Exception e) {
                    modified = false;
                    this.logger.error("Error in Modify ace", (Throwable)e);
                }
            }
            catch (Exception e) {
                this.logger.error("Error in Add or Modify Permissions in AccessManager", (Throwable)e);
                modified = false;
            }
            finally {
                if (getMethod != null) {
                    getMethod.releaseConnection();
                }
            }
        }
        return modified;
    }

    public Map<String, List<String>> getEACL(String absPath) throws InternalErrorException {
        HashMap<String, List<String>> map;
        block9: {
            this.logger.debug("GET ACL of resource " + absPath);
            map = null;
            GetMethod getMethod = null;
            try {
                HttpClient httpClient = new HttpClient();
                String requestUrl = this.servlets.get("GetEACL").uri().toString() + "?absPath=" + URLEncoder.encode(absPath, "UTF-8");
                getMethod = new GetMethod(requestUrl);
                TokenUtility.setHeader(getMethod);
                httpClient.executeMethod((HttpMethod)getMethod);
                XStream xstream = new XStream();
                try {
                    if (getMethod.getResponseBodyAsString() == null) {
                        map = new HashMap();
                        break block9;
                    }
                    map = (Map)xstream.fromXML(getMethod.getResponseBodyAsString());
                }
                catch (Exception e) {
                    this.logger.error("Error retrieving EACL", (Throwable)e);
                }
            }
            catch (Exception e) {
                this.logger.error("Error modifing ACLs: " + e);
                throw new InternalErrorException((Throwable)e);
            }
            finally {
                if (getMethod != null) {
                    getMethod.releaseConnection();
                }
            }
        }
        return map;
    }

    public boolean setReadOnlyACL(List<String> users, String absPath) throws InternalErrorException {
        this.logger.debug("Set READ ONLY ACL on resource " + absPath + " for users: " + users.toString());
        boolean flag = true;
        ArrayList<String> privileges = new ArrayList<String>();
        privileges.add("jcr:read=granted");
        try {
            flag = this.modifyAce(users, absPath, privileges, null);
        }
        catch (Exception e) {
            this.logger.error("Error setting WriteOwner to users " + users.toString() + " to path " + absPath);
            throw new InternalErrorException((Throwable)e);
        }
        return flag;
    }

    public boolean setWriteOwnerACL(List<String> users, String absPath) throws InternalErrorException {
        this.logger.debug("Set WRITE OWN ACL on resource " + absPath + " for users: " + users.toString());
        boolean flag = true;
        ArrayList<String> privileges = new ArrayList<String>();
        privileges.add("jcr:write=granted");
        try {
            flag = this.modifyAce(users, absPath, privileges, null);
        }
        catch (Exception e) {
            this.logger.error("Error setting WriteOwner to users " + users.toString() + " to path " + absPath);
            throw new InternalErrorException((Throwable)e);
        }
        this.logger.debug("Ace modified");
        return flag;
    }

    public boolean setWriteAllACL(List<String> users, String absPath) throws InternalErrorException {
        this.logger.debug("Set WRITE ALL ACL on resource " + absPath + " for users: " + users.toString());
        ArrayList<String> privileges = new ArrayList<String>();
        privileges.add("hl:writeAll=granted");
        boolean flag = true;
        try {
            flag = this.modifyAce(users, absPath, privileges, null);
        }
        catch (Exception e) {
            this.logger.error("Error setting Write All to users " + users.toString() + " to path " + absPath);
            throw new InternalErrorException((Throwable)e);
        }
        return flag;
    }

    public boolean setAccessDenied(List<String> users, String absPath) throws InternalErrorException {
        this.logger.debug("Set Access Denide on resource " + absPath + " for users: " + users.toString());
        ArrayList<String> privileges = new ArrayList<String>();
        privileges.add("jcr:read=denied");
        boolean flag = true;
        try {
            flag = this.modifyAce(users, absPath, privileges, null);
        }
        catch (Exception e) {
            this.logger.error("Error removing Read privilege to users " + users.toString() + " to path " + absPath);
            flag = false;
        }
        return flag;
    }

    public boolean setAdminACL(List<String> users, String absPath) throws InternalErrorException {
        this.logger.debug("Set ADMIN ACL on resource " + absPath + " for users: " + users.toString());
        ArrayList<String> privileges = new ArrayList<String>();
        privileges.add("jcr:all=granted");
        boolean flag = false;
        try {
            flag = this.modifyAce(users, absPath, privileges, null);
        }
        catch (Exception e) {
            this.logger.error("Error setting Admin to users " + users.toString() + " to path " + absPath);
            throw new InternalErrorException((Throwable)e);
        }
        return flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteAces(String resourcePath, List<String> users) throws InternalErrorException {
        this.logger.debug("Delete ACES on resource " + resourcePath + " for users: " + users.toString());
        GetMethod getMethod = null;
        Boolean modified = true;
        try {
            HttpClient httpClient = new HttpClient();
            StringBuilder applyTo = new StringBuilder();
            for (String user : users) {
                applyTo.append("&applyTo=" + user);
            }
            String requestUrl = this.servlets.get("DeleteAcesServlet").uri().toString() + "?absPath=" + URLEncoder.encode(resourcePath, "UTF-8") + applyTo;
            getMethod = new GetMethod(requestUrl);
            TokenUtility.setHeader(getMethod);
            httpClient.executeMethod((HttpMethod)getMethod);
            this.logger.debug("Response DeleteAcesServlet: " + getMethod.getResponseBodyAsString());
            if (getMethod != null) {
                getMethod.releaseConnection();
            }
            XStream xstream = new XStream();
            modified = (Boolean)xstream.fromXML(getMethod.getResponseBodyAsString());
        }
        catch (Exception e) {
            if (getMethod != null) {
                getMethod.releaseConnection();
            }
            this.logger.error("Error deleting Permissions in AccessManager", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (getMethod != null) {
                getMethod.releaseConnection();
            }
        }
        return modified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, List<String>> getDeniedMap(String absPath) throws RepositoryException, InternalErrorException {
        this.logger.debug("Get Denide map for resource " + absPath);
        Map map = null;
        GetMethod getMethod = null;
        try {
            HttpClient httpClient = new HttpClient();
            XStream xstream = new XStream();
            String requestUrl = this.servlets.get("GetDeniedMap").uri().toString() + "?absPath=" + URLEncoder.encode(absPath, "UTF-8");
            getMethod = new GetMethod(requestUrl);
            TokenUtility.setHeader(getMethod);
            httpClient.executeMethod((HttpMethod)getMethod);
            map = (Map)xstream.fromXML(getMethod.getResponseBodyAsString());
        }
        catch (Exception e) {
            this.logger.error("Error GET_DENIED_MAP ", (Throwable)e);
        }
        finally {
            if (getMethod != null) {
                getMethod.releaseConnection();
            }
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canAddChildren(String user, String absPath) {
        this.logger.debug("Check if " + user + " can add children on resource " + absPath);
        GetMethod getMethod = null;
        Boolean modified = true;
        try {
            HttpClient httpClient = new HttpClient();
            String requestUrl = this.servlets.get("CanAddChildren").uri().toString() + "?login=" + user + "&absPath=" + URLEncoder.encode(absPath, "UTF-8");
            getMethod = new GetMethod(requestUrl);
            TokenUtility.setHeader(getMethod);
            httpClient.executeMethod((HttpMethod)getMethod);
            this.logger.debug("Response DeleteAcesServlet: " + getMethod.getResponseBodyAsString());
            if (getMethod != null) {
                getMethod.releaseConnection();
            }
            XStream xstream = new XStream();
            modified = (Boolean)xstream.fromXML(getMethod.getResponseBodyAsString());
        }
        catch (Exception e) {
            this.logger.error("Error adding children in AccessManager", (Throwable)e);
            modified = false;
        }
        finally {
            if (getMethod != null) {
                getMethod.releaseConnection();
            }
        }
        return modified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canDeleteChildren(String user, String absPath) {
        this.logger.debug("Check if " + user + " can delete children of resource " + absPath);
        GetMethod getMethod = null;
        Boolean modified = true;
        try {
            HttpClient httpClient = new HttpClient();
            String requestUrl = this.servlets.get("CanDeleteChildren").uri().toString() + "?login=" + user + "&absPath=" + URLEncoder.encode(absPath, "UTF-8");
            getMethod = new GetMethod(requestUrl);
            TokenUtility.setHeader(getMethod);
            httpClient.executeMethod((HttpMethod)getMethod);
            this.logger.debug("Response DeleteAcesServlet: " + getMethod.getResponseBodyAsString());
            if (getMethod != null) {
                getMethod.releaseConnection();
            }
            XStream xstream = new XStream();
            modified = (Boolean)xstream.fromXML(getMethod.getResponseBodyAsString());
        }
        catch (Exception e) {
            this.logger.error("Error deleting children Permissions in AccessManager", (Throwable)e);
            modified = false;
        }
        finally {
            if (getMethod != null) {
                getMethod.releaseConnection();
            }
        }
        return modified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canDelete(String user, String absPath, boolean root) {
        this.logger.debug("Check if " + user + " can delete resource " + absPath);
        GetMethod getMethod = null;
        Boolean modified = true;
        try {
            HttpClient httpClient = new HttpClient();
            String requestUrl = this.servlets.get("CanDelete").uri().toString() + "?login=" + user + "&isRoot=" + root + "&absPath=" + URLEncoder.encode(absPath, "UTF-8");
            getMethod = new GetMethod(requestUrl);
            TokenUtility.setHeader(getMethod);
            httpClient.executeMethod((HttpMethod)getMethod);
            this.logger.debug("Response DeleteAcesServlet: " + getMethod.getResponseBodyAsString());
            if (getMethod != null) {
                getMethod.releaseConnection();
            }
            XStream xstream = new XStream();
            modified = (Boolean)xstream.fromXML(getMethod.getResponseBodyAsString());
        }
        catch (Exception e) {
            this.logger.error("Error deleting Permissions in AccessManager", (Throwable)e);
            modified = false;
        }
        finally {
            if (getMethod != null) {
                getMethod.releaseConnection();
            }
        }
        return modified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canModifyProperties(String user, String absPath, boolean root) {
        this.logger.debug("Check if " + user + " can modify resource " + absPath);
        GetMethod getMethod = null;
        Boolean modified = true;
        try {
            HttpClient httpClient = new HttpClient();
            String requestUrl = this.servlets.get("CanModifyProperties").uri().toString() + "?login=" + user + "&isRoot=" + root + "&absPath=" + URLEncoder.encode(absPath, "UTF-8");
            getMethod = new GetMethod(requestUrl);
            TokenUtility.setHeader(getMethod);
            httpClient.executeMethod((HttpMethod)getMethod);
            this.logger.debug("Response DeleteAcesServlet: " + getMethod.getResponseBodyAsString());
            if (getMethod != null) {
                getMethod.releaseConnection();
            }
            XStream xstream = new XStream();
            modified = (Boolean)xstream.fromXML(getMethod.getResponseBodyAsString());
        }
        catch (Exception e) {
            this.logger.error("Error modifying privileges in AccessManager", (Throwable)e);
            modified = false;
        }
        finally {
            if (getMethod != null) {
                getMethod.releaseConnection();
            }
        }
        return modified;
    }

    public boolean canReadNode(String user, String absPath) throws InternalErrorException {
        this.logger.debug("Check if " + user + " can read resource " + absPath);
        GetMethod getMethod = null;
        Boolean canRead = false;
        try {
            HttpClient httpClient = new HttpClient();
            String requestUrl = this.servlets.get("CanReadNode").uri().toString() + "?login=" + user + "&absPath=" + URLEncoder.encode(absPath, "UTF-8");
            getMethod = new GetMethod(requestUrl);
            TokenUtility.setHeader(getMethod);
            httpClient.executeMethod((HttpMethod)getMethod);
            this.logger.debug("Response canReadNode: " + getMethod.getResponseBodyAsString());
            if (getMethod != null) {
                getMethod.releaseConnection();
            }
            XStream xstream = new XStream();
            canRead = (Boolean)xstream.fromXML(getMethod.getResponseBodyAsString());
        }
        catch (Exception e) {
            this.logger.error("Error reading privileges in AccessManager", (Throwable)e);
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            if (getMethod != null) {
                getMethod.releaseConnection();
            }
        }
        return canRead;
    }
}

