/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.framework.core.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.application.framework.core.util.ServiceType;
import org.gcube.common.resources.gcore.GCoreEndpoint;
import org.gcube.common.resources.gcore.ServiceInstance;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceUtils {
    private static final Logger logger = LoggerFactory.getLogger(ServiceUtils.class);

    public static String getEprAddressOfService(String srvClass, String srvName, String srvType, ASLSession session) {
        return ServiceUtils.getEprAddressOfService(srvClass, srvName, srvType, session.getScope());
    }

    public static String getEprAddressOfService(String srvClass, String srvName, String srvType, String scope) {
        XQuery query;
        DiscoveryClient client;
        ScopeProvider.instance.set(scope);
        ArrayList<String> endpoints = new ArrayList<String>();
        if (srvType == ServiceType.STATEFULL.name()) {
            logger.debug("Performing query for stateful services with serviceClass=" + srvClass + " serviceName=" + srvName + " serviceType=" + srvType);
            client = ICFactory.clientFor(ServiceInstance.class);
            query = ICFactory.queryFor(ServiceInstance.class);
            query.addCondition("$resource/Profile/ServiceClass/text() eq '" + srvClass + "'").addCondition("$resource/Profile/ServiceName/text() eq '" + srvName + "'");
            List endpointsList = client.submit((Query)query);
            for (ServiceInstance endpoint : endpointsList) {
                endpoints.add(endpoint.endpoint().toString());
            }
        } else {
            logger.debug("Performing SIMPLE or FACTORY query with serviceClass=" + srvClass + " serviceName=" + srvName + " serviceType=" + srvType);
            client = ICFactory.clientFor(GCoreEndpoint.class);
            query = ICFactory.queryFor(GCoreEndpoint.class);
            query.addCondition("$resource/Profile/ServiceClass/text() eq '" + srvClass + "'").addCondition("$resource/Profile/ServiceName/text() eq '" + srvName + "'");
            List endpointsList = client.submit((Query)query);
            if (srvType == ServiceType.FACTORY.name()) {
                for (GCoreEndpoint endpoint : endpointsList) {
                    for (GCoreEndpoint.Profile.Endpoint ep : endpoint.profile().endpoints()) {
                        if (ep.uri().toString().indexOf("Factory") == -1) continue;
                        endpoints.add(ep.uri().toString());
                    }
                }
            } else {
                for (GCoreEndpoint endpoint : endpointsList) {
                    for (GCoreEndpoint.Profile.Endpoint ep : endpoint.profile().endpoints()) {
                        endpoints.add(ep.uri().toString());
                    }
                }
            }
        }
        Random rand = new Random();
        int random = rand.nextInt(endpoints.size());
        logger.debug("Returning Endpoint URI: " + (String)endpoints.get(random));
        return (String)endpoints.get(random);
    }
}

