/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler.ir.instructions;

import java.util.Map;
import org.jruby.RubyArray;
import org.jruby.compiler.ir.Operation;
import org.jruby.compiler.ir.instructions.Instr;
import org.jruby.compiler.ir.instructions.OneOperandInstr;
import org.jruby.compiler.ir.operands.Label;
import org.jruby.compiler.ir.operands.Operand;
import org.jruby.compiler.ir.operands.Variable;
import org.jruby.compiler.ir.representations.InlinerInfo;
import org.jruby.interpreter.InterpreterContext;
import org.jruby.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetArrayInstr
extends OneOperandInstr {
    public final int index;
    public final boolean all;

    public GetArrayInstr(Variable dest, Operand array, int index2, boolean getRestOfArray) {
        super(Operation.GET_ARRAY, dest, array);
        this.index = index2;
        this.all = getRestOfArray;
    }

    @Override
    public String toString() {
        return "\t" + this.result + " = " + this.argument + "[" + this.index + (this.all ? ":END" : "") + "] (GET_ARRAY)";
    }

    @Override
    public Operand simplifyAndGetResult(Map<Operand, Operand> valueMap) {
        this.simplifyOperands(valueMap);
        Operand val = this.argument.getValue(valueMap);
        return val.fetchCompileTimeArrayElement(this.index, this.all);
    }

    @Override
    public Instr cloneForInlining(InlinerInfo ii) {
        return new GetArrayInstr(ii.getRenamedVariable(this.result), this.argument.cloneForInlining(ii), this.index, this.all);
    }

    @Override
    public Label interpret(InterpreterContext interp, IRubyObject self) {
        RubyArray array = (RubyArray)this.getArg().retrieve(interp);
        this.getResult().store(interp, array.entry(this.index));
        return null;
    }
}

