/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler.ir.operands;

import java.util.List;
import java.util.Map;
import org.jruby.RubyRange;
import org.jruby.compiler.ir.IRClass;
import org.jruby.compiler.ir.operands.Operand;
import org.jruby.compiler.ir.operands.Variable;
import org.jruby.compiler.ir.representations.InlinerInfo;
import org.jruby.interpreter.InterpreterContext;
import org.jruby.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Range
extends Operand {
    Operand begin;
    Operand end;
    boolean exclusive;

    public Range(Operand begin2, Operand end2, boolean exclusive2) {
        this.begin = begin2;
        this.end = end2;
        this.exclusive = exclusive2;
    }

    public String toString() {
        return "(" + this.begin + (this.exclusive ? ".." : "...") + this.end + "):Range";
    }

    @Override
    public boolean isConstant() {
        return this.begin.isConstant() && this.end.isConstant();
    }

    @Override
    public Operand fetchCompileTimeArrayElement(int argIndex, boolean getSubArray) {
        if (!this.isConstant()) {
            return null;
        }
        return null;
    }

    @Override
    public IRClass getTargetClass() {
        return IRClass.getCoreClass("Range");
    }

    @Override
    public boolean isNonAtomicValue() {
        return true;
    }

    @Override
    public Operand getSimplifiedOperand(Map<Operand, Operand> valueMap) {
        this.begin = this.begin.getSimplifiedOperand(valueMap);
        this.end = this.end.getSimplifiedOperand(valueMap);
        return this;
    }

    @Override
    public void addUsedVariables(List<Variable> l) {
        this.begin.addUsedVariables(l);
        this.end.addUsedVariables(l);
    }

    @Override
    public Operand cloneForInlining(InlinerInfo ii) {
        return this.isConstant() ? this : new Range(this.begin.cloneForInlining(ii), this.end.cloneForInlining(ii), this.exclusive);
    }

    @Override
    public Object retrieve(InterpreterContext interp) {
        return RubyRange.newRange(interp.getRuntime(), interp.getContext(), (IRubyObject)this.begin.retrieve(interp), (IRubyObject)this.end.retrieve(interp), this.exclusive);
    }
}

